/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.api;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.rm.common.bridges.api.DevelopmentImplementation;
import com.atlassian.rm.common.bridges.api.FeatureAccessor;
import com.atlassian.rm.common.bridges.api.InvalidBridgeException;
import com.atlassian.rm.common.bridges.api.RequiredFeatures;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.SupportedVersionsUtils;
import com.atlassian.rm.common.bridges.api.Version;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;

public class BridgeManager<TSpringInterface> {
    @TenantAware(value=TenancyScope.TENANTED)
    private final Iterable<TSpringInterface> bridges;
    private final Optional<FeatureAccessor> darkFeatureAccessor;

    public BridgeManager(Iterable<TSpringInterface> bridges) {
        this(bridges, (Optional<FeatureAccessor>)Optional.absent());
    }

    public BridgeManager(Iterable<TSpringInterface> bridges, Optional<FeatureAccessor> darkFeatureAccessor) {
        this.bridges = bridges;
        this.darkFeatureAccessor = darkFeatureAccessor;
        this.validateBridges(bridges);
    }

    public Optional<TSpringInterface> getSupportedBridge(final Version apiVersion) {
        Iterable availableBridges = Iterables.filter(this.bridges, (Predicate)new Predicate<TSpringInterface>(){

            public boolean apply(TSpringInterface bridge) {
                if (BridgeManager.this.isApiVersionSupported(bridge, apiVersion)) {
                    RequiredFeatures requiredFeatures = bridge.getClass().getAnnotation(RequiredFeatures.class);
                    if (requiredFeatures != null) {
                        FeatureAccessor featureAccessor = (FeatureAccessor)BridgeManager.this.darkFeatureAccessor.get();
                        for (String key : requiredFeatures.value()) {
                            if (featureAccessor.isEnabled(key)) continue;
                            return false;
                        }
                        for (String key : requiredFeatures.unless()) {
                            if (!featureAccessor.isEnabled(key)) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        });
        if (!availableBridges.iterator().hasNext()) {
            return Optional.absent();
        }
        Optional devAnnotatedBridge = Iterables.tryFind((Iterable)availableBridges, (Predicate)new Predicate<TSpringInterface>(){

            public boolean apply(@Nullable TSpringInterface bridge) {
                return bridge != null && bridge.getClass().isAnnotationPresent(DevelopmentImplementation.class);
            }
        });
        return devAnnotatedBridge.or(Optional.of(availableBridges.iterator().next()));
    }

    public Collection<TSpringInterface> getAllVersionCompatibleBridges(Version apiVersion) {
        ArrayList supportedBridges = Lists.newArrayList();
        for (TSpringInterface bridge : this.bridges) {
            if (!this.isApiVersionSupported(bridge, apiVersion)) continue;
            supportedBridges.add(bridge);
        }
        return supportedBridges;
    }

    private boolean isApiVersionSupported(TSpringInterface bridge, Version apiVersion) {
        for (SupportedVersions supportedVersions : SupportedVersionsUtils.getAllSupportedVersions(bridge)) {
            if (!apiVersion.isSupported(supportedVersions)) continue;
            return true;
        }
        return false;
    }

    private void validateBridges(Iterable<TSpringInterface> bridges) {
        for (TSpringInterface bridge : bridges) {
            if (SupportedVersionsUtils.getAllSupportedVersions(bridge).isEmpty()) {
                throw new InvalidBridgeException("Bridge '" + bridge.getClass() + "' requires a SupportedVersions or MultipleSupportedVersions annotation.");
            }
            RequiredFeatures requiredFeatures = bridge.getClass().getAnnotation(RequiredFeatures.class);
            if (requiredFeatures == null || this.darkFeatureAccessor.isPresent()) continue;
            throw new InvalidBridgeException("Bridge '" + bridge.getClass() + "' has a Dark Feature annotation but no dark feature accessor is provided.");
        }
    }
}

