/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.NumberValueConverter;
import com.atlassian.rm.common.bridges.lucene.StoryPointDecimalFormat;
import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.ParsePosition;

abstract class BaseNumberValueConverter
implements NumberValueConverter {
    private final DecimalFormat luceneFormat;

    BaseNumberValueConverter() {
        this(new StoryPointDecimalFormat());
    }

    BaseNumberValueConverter(DecimalFormat luceneFormat) {
        this.luceneFormat = luceneFormat;
    }

    @Override
    public String getStringForLucene(Double value) {
        if (value == null) {
            return null;
        }
        return this.luceneFormat.format(value);
    }

    @Override
    public String getStringForLucene(Number value) {
        if (value instanceof Double) {
            return this.getStringForLucene(value.doubleValue());
        }
        if (value instanceof Long) {
            return this.getStringForLucene(value.longValue());
        }
        return null;
    }

    @Override
    public Double getDoubleFromLucene(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        ParsePosition pp = new ParsePosition(0);
        Number aNumber = this.luceneFormat.parse(value, pp);
        if (aNumber == null || pp.getIndex() != value.length()) {
            throw new NumberFormatException(String.format("Could not parse double from string %s", value));
        }
        return aNumber.doubleValue();
    }
}

