/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene.collectors;

import com.atlassian.rm.common.bridges.lucene.collectors.FirstPassGroupingCollector73;
import com.atlassian.rm.common.bridges.lucene.collectors.FirstPassGroupingResult;
import com.atlassian.rm.common.bridges.lucene.collectors.IssueIndexType;
import com.atlassian.rm.common.bridges.lucene.collectors.SortedFirstPassGroupingResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;

public class SortedAllGroupsFirstPassGroupCollector73
extends FirstPassGroupingCollector73 {
    private static final String UNKNOWN_SORT_FIELD_DOC_PATTERN = "__UNINDEXED_SORT_%s";
    private final String groupField;
    private final String sortField;
    private final Map<IndexReader, IssueIndexType> readerStack;
    private final Map<String, String> groupsBySort;
    private final Map<String, String> sortsByGroup;
    private final Map<String, Boolean> indexedSortsByGroup;
    private LeafReader currentReader;
    private SortedDocValues groupDocValues;
    private SortedDocValues sortDocValues;

    public SortedAllGroupsFirstPassGroupCollector73(String groupField, String sortField, Map<IndexReader, IssueIndexType> readerStack) {
        this.groupField = groupField;
        this.sortField = sortField;
        this.readerStack = readerStack;
        this.groupsBySort = Maps.newTreeMap();
        this.sortsByGroup = Maps.newHashMap();
        this.indexedSortsByGroup = Maps.newHashMap();
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.currentReader = context.reader();
        this.groupDocValues = DocValues.getSorted((LeafReader)this.currentReader, (String)this.groupField);
        this.sortDocValues = DocValues.getSorted((LeafReader)this.currentReader, (String)this.sortField);
    }

    public void collect(int doc) throws IOException {
        boolean indexedSort;
        String sort;
        if (doc < 0 || doc >= this.currentReader.maxDoc() || !this.groupDocValues.advanceExact(doc) || !this.sortDocValues.advanceExact(doc)) {
            return;
        }
        int groupOrd = this.groupDocValues.ordValue();
        if (groupOrd < 0) {
            return;
        }
        int sortOrd = this.sortDocValues.ordValue();
        if (sortOrd != 0) {
            sort = this.sortDocValues.lookupOrd(sortOrd).utf8ToString();
            indexedSort = true;
        } else {
            sort = String.format(UNKNOWN_SORT_FIELD_DOC_PATTERN, UUID.randomUUID().toString());
            indexedSort = false;
        }
        String group = this.groupDocValues.lookupOrd(groupOrd).utf8ToString();
        if (this.sortsByGroup.containsKey(group)) {
            if (!indexedSort) {
                return;
            }
            IssueIndexType sourceType = this.readerStack.get(this.subReader(doc, (IndexReader)this.currentReader));
            if (sourceType != IssueIndexType.SCENARIO && this.indexedSortsByGroup.get(group).booleanValue()) {
                return;
            }
            this.groupsBySort.remove(this.sortsByGroup.remove(group));
        }
        this.groupsBySort.put(sort, group);
        this.sortsByGroup.put(group, sort);
        this.indexedSortsByGroup.put(group, indexedSort);
    }

    private IndexReader subReader(int doc, IndexReader reader) {
        return ((LeafReaderContext)reader.leaves().get(ReaderUtil.subIndex((int)doc, (List)reader.leaves()))).reader();
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public FirstPassGroupingResult getResult() {
        return new SortedFirstPassGroupingResult(Lists.newArrayList(this.groupsBySort.values()));
    }
}

