/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.pkqdsl.legacy;

import com.atlassian.rm.common.pkqdsl.legacy.DialectConfiguration;
import com.atlassian.rm.common.pkqdsl.legacy.DialectHelper;
import com.atlassian.rm.common.pkqdsl.legacy.DialectProvider;
import com.atlassian.rm.common.pkqdsl.legacy.MemoizingResettingReference;
import com.atlassian.rm.common.pkqdsl.legacy.SchemaProvider;
import com.google.common.base.Function;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.HSQLDBTemplates;
import com.querydsl.sql.MySQLTemplates;
import com.querydsl.sql.OracleTemplates;
import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.types.AbstractType;
import com.querydsl.sql.types.Null;
import com.querydsl.sql.types.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.pkqdsl.legacy.DefaultDialectConfiguration")
public class DefaultDialectConfiguration
implements DialectConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DefaultDialectConfiguration.class);
    private final SchemaProvider schemaProvider;
    private final MemoizingResettingReference<Connection, DialectProvider.Config> configurationReference = new MemoizingResettingReference<Connection, DialectProvider.Config>(new Function<Connection, DialectProvider.Config>(){

        public DialectProvider.Config apply(@Nullable Connection connection) {
            return DefaultDialectConfiguration.this.detect(connection);
        }
    });
    private static Map<String, Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase>> support = new LinkedHashMap<String, Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase>>();

    @Autowired
    public DefaultDialectConfiguration(SchemaProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    @Override
    public DialectProvider.Config getDialectConfig(Connection connection) {
        this.schemaProvider.prime(connection);
        return this.configurationReference.get(connection);
    }

    private DialectProvider.Config detect(Connection connection) {
        Pair<SQLTemplates, DialectProvider.SupportedDatabase> pair = this.buildTemplates(connection);
        SQLTemplates sqlTemplates = pair.getLeft();
        Configuration configuration = this.enrich(new Configuration(sqlTemplates));
        configuration.register((Type)new NullType());
        return new DialectProvider.Config(sqlTemplates, configuration, this.buildDatabaseInfo(pair.getRight(), connection));
    }

    @Override
    public SQLTemplates.Builder enrich(SQLTemplates.Builder builder) {
        return builder.newLineToSingleSpace().quote();
    }

    @Override
    public Configuration enrich(Configuration configuration) {
        return configuration;
    }

    private Pair<SQLTemplates, DialectProvider.SupportedDatabase> buildTemplates(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String connStr = metaData.getURL();
            Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase> pair = this.getDBTemplate(connStr, metaData);
            if (pair == null) {
                throw new UnsupportedOperationException(String.format("Unable to detect QueryDSL template support for database %s", connStr));
            }
            SQLTemplates templates = this.enrich(pair.getLeft()).build();
            return Pair.of(templates, pair.getRight());
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to enquire on JDBC metadata to configure QueryDSL", e);
        }
    }

    @Nullable
    Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase> getDBTemplate(String connStr, DatabaseMetaData metaData) throws SQLException {
        Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase> sqlTemplatePair = DialectHelper.isSQLServer(connStr) ? DialectHelper.getSQLServerDBTemplate(metaData) : this.getStaticSupportedDBTemplate(connStr);
        if (sqlTemplatePair != null) {
            log.debug("SQL template has been initialized successfully {}", (Object)sqlTemplatePair.toString());
        } else {
            log.warn("System was unable to initialize SQL template for {}", (Object)connStr);
        }
        return sqlTemplatePair;
    }

    @Nullable
    Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase> getStaticSupportedDBTemplate(String connStr) {
        Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase> pair = null;
        for (Map.Entry<String, Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase>> entry : support.entrySet()) {
            if (!connStr.contains(entry.getKey())) continue;
            pair = entry.getValue();
            break;
        }
        return pair;
    }

    private DialectProvider.DatabaseInfo buildDatabaseInfo(DialectProvider.SupportedDatabase supportedDatabase, Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            return new DialectProvider.DatabaseInfo(supportedDatabase, metaData.getDatabaseProductName(), metaData.getDatabaseProductVersion(), metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion(), metaData.getDriverName(), metaData.getDriverMajorVersion(), metaData.getDriverMinorVersion());
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to enquire on JDBC metadata to determine DatabaseInfo", e);
        }
    }

    static {
        support.put(":postgresql:", Pair.of(PostgreSQLTemplates.builder(), DialectProvider.SupportedDatabase.POSTGRESSQL));
        support.put(":oracle:", Pair.of(OracleTemplates.builder(), DialectProvider.SupportedDatabase.ORACLE));
        support.put(":hsqldb:", Pair.of(HSQLDBTemplates.builder(), DialectProvider.SupportedDatabase.HSQLDB));
        support.put(":mysql:", Pair.of(MySQLTemplates.builder(), DialectProvider.SupportedDatabase.MYSQL));
        support.put(":h2:", Pair.of(H2Templates.builder(), DialectProvider.SupportedDatabase.H2));
    }

    private static class NullType
    extends AbstractType<Null> {
        public NullType() {
            super(0);
        }

        public Null getValue(ResultSet rs, int startIndex) {
            return Null.DEFAULT;
        }

        public Class<Null> getReturnedClass() {
            return Null.class;
        }

        public void setValue(PreparedStatement st, int startIndex, Null value) throws SQLException {
            if (!ArrayUtils.isNotEmpty(this.getSQLTypes())) {
                throw new RuntimeException("Unable to set database column to null");
            }
            st.setNull(startIndex, this.getSQLTypes()[0]);
        }

        public String getLiteral(Null value) {
            return "null";
        }
    }
}

