/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.DependencyIgnoredSprintWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class IgnoredDependencyViolationDetector {
    IgnoredDependencyViolationDetector() {
    }

    Set<IScheduleWarning> getDependencyViolations(LinkedHashSet<IEpisodeSchedule> solutions, IRoadmapProblem problem) {
        Set<IActivitySetSchedule> allActivitySetSchedules = IgnoredDependencyViolationDetector.getActivitySetSchedules(solutions);
        Set<IUnstructuredItemSchedule> allUnstrucutredSchedules = IgnoredDependencyViolationDetector.getUnstructuredSchedules(solutions);
        HashMap map = Maps.newHashMap();
        map.putAll(RmIdentifiableUtils.createIdMap(allActivitySetSchedules));
        map.putAll(IgnoredDependencyViolationDetector.getMergedUnstructured(allUnstrucutredSchedules));
        HashSet dependencyWarnings = Sets.newHashSet();
        block0: for (IProcessingItem item : problem.getBacklog().getProcessingItems()) {
            IIntegerInterval itemInterval = (IIntegerInterval)map.get(item.getId());
            if (itemInterval == null) continue;
            Set<IProcessingItem> transitivePrerequisites = problem.getBacklog().getDependencyDefinition().getTransitivePrerequisites(item);
            for (IProcessingItem prerequisite : transitivePrerequisites) {
                IIntegerInterval prerequisiteInterval = (IIntegerInterval)map.get(prerequisite.getId());
                if (prerequisiteInterval == null || !IgnoredDependencyViolationDetector.hasIgnoredDependency(itemInterval, prerequisiteInterval, problem.getProcessingDefinition())) continue;
                dependencyWarnings.add(new DependencyIgnoredSprintWarning(item.getId()));
                continue block0;
            }
        }
        return dependencyWarnings;
    }

    private static boolean hasIgnoredDependency(IIntegerInterval itemInterval, IIntegerInterval prerequisiteInterval, IProcessingDefinition processingDefinition) {
        if (processingDefinition.isSyncDependeeStartEnabled()) {
            return itemInterval.getStart() < prerequisiteInterval.getStart();
        }
        return itemInterval.getStart() <= prerequisiteInterval.getEnd();
    }

    private static Map<String, IIntegerInterval> getMergedUnstructured(Set<IUnstructuredItemSchedule> allUnstrucutredSchedules) {
        HashMap map = Maps.newHashMap();
        for (IUnstructuredItemSchedule schedule : allUnstrucutredSchedules) {
            String id = schedule.getId();
            if (!map.containsKey(id)) {
                map.put(id, schedule);
                continue;
            }
            map.put(id, RmUtils.getMergedIntervals(Lists.newArrayList((Object[])new IIntegerInterval[]{(IIntegerInterval)map.get(id), schedule})));
        }
        return map;
    }

    private static Set<IUnstructuredItemSchedule> getUnstructuredSchedules(LinkedHashSet<IEpisodeSchedule> solutions) {
        HashSet union = Sets.newHashSet();
        for (IEpisodeSchedule episode : solutions) {
            union.addAll(episode.getUnstructuredItemSchedules());
        }
        return union;
    }

    private static Set<IActivitySetSchedule> getActivitySetSchedules(LinkedHashSet<IEpisodeSchedule> solutions) {
        HashSet union = Sets.newHashSet();
        for (IEpisodeSchedule episode : solutions) {
            union.addAll(episode.getActivitySetSchedules());
        }
        return union;
    }
}

