/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.IBoundAssignmentProblemCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.IGroupActivityScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.IGroupActivitySchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.TaskAssignmentIgnoringAssignmentProblemCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ActivitySchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ISingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.SingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentProblemSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblemSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundedAssignmentProblemSolver;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RobustGroupActivityScheduler
implements IGroupActivityScheduler {
    private static final Log LOGGER = Log.with(RobustGroupActivityScheduler.class);
    private final BoundAssignmentProblemSolver boundAssignmentProblemSolver;
    private final IBoundAssignmentProblemCreator boundAssignmentProblemCreator;

    RobustGroupActivityScheduler(BoundAssignmentProblemSolver boundAssignmentProblemSolver, IBoundAssignmentProblemCreator boundAssignmentProblemCreator) {
        this.boundAssignmentProblemSolver = boundAssignmentProblemSolver;
        this.boundAssignmentProblemCreator = boundAssignmentProblemCreator;
    }

    public RobustGroupActivityScheduler(int maxTestAssignmentsPerTeamStage, CancellationState cancellationState) {
        this(new BoundedAssignmentProblemSolver(maxTestAssignmentsPerTeamStage, cancellationState), new TaskAssignmentIgnoringAssignmentProblemCreator());
    }

    @Override
    public Optional<IActivitySchedule> tryScheduleWithTimeBound(IGroupActivitySchedulingProblem problem, int timeLimit) throws InterruptedException {
        LogUtil.debug(LOGGER, "solve problem with time bound %s: %s", timeLimit, problem);
        Optional<BoundAssignmentProblem> boundProblem = this.boundAssignmentProblemCreator.tryCreate(problem, timeLimit);
        if (!boundProblem.isPresent()) {
            LogUtil.debug(LOGGER, "unsolvable problem specification");
            return Optional.absent();
        }
        Optional<AssignmentProblemSolution> assignmentSolution = this.boundAssignmentProblemSolver.trySolve((BoundAssignmentProblem)boundProblem.get());
        if (!assignmentSolution.isPresent()) {
            LogUtil.debug(LOGGER, "no solution found");
            return Optional.absent();
        }
        ISingleResourceGroupAssignment assignment = SingleResourceGroupAssignment.createInstanceFromAssignment((AssignmentProblemSolution)assignmentSolution.get(), problem);
        int releaseTime = problem.getLowerTimeBound();
        ActivitySchedule solution = new ActivitySchedule(problem.getActivity(), assignment, releaseTime);
        LogUtil.debug(LOGGER, "found solution: %s", solution);
        return Optional.of((Object)solution);
    }
}

