/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.DefaultFixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotItemsSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotsAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.IFixedSlotsAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.PeriodAssignmentProblemRetransformer;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.PeriodAssignmentProblemTransformationResult;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.PeriodAssignmentProblemTransformer;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.IterativePeriodAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.OverbookedPeriodAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.PeriodAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.google.common.collect.Sets;
import java.util.HashSet;

public class IterativePerItemAssignmentSolver
implements FixedSlotsAssignmentSolver {
    private static final Log LOGGER = Log.with(IterativePerItemAssignmentSolver.class);
    private final PeriodAssignmentProblemTransformer transformer;
    private final PeriodAssignmentSolver solver;
    private final PeriodAssignmentProblemRetransformer retransformer;

    public IterativePerItemAssignmentSolver() {
        this(new PeriodAssignmentProblemTransformer(), new IterativePeriodAssignmentSolver(), new PeriodAssignmentProblemRetransformer());
    }

    public IterativePerItemAssignmentSolver(PeriodAssignmentProblemTransformer transformer, PeriodAssignmentSolver solver, PeriodAssignmentProblemRetransformer retransformer) {
        this.transformer = transformer;
        this.solver = solver;
        this.retransformer = retransformer;
    }

    @Override
    public FixedSlotsAssignmentSolution solve(IFixedSlotsAssignmentProblem slotsAssignmentProblem) {
        LOGGER.debug("start solving fixed slot problems", new Object[0]);
        HashSet slotSolutions = Sets.newHashSet();
        for (IWorkSlot slot : slotsAssignmentProblem.getWorkSlotsWithAssignedItems()) {
            slotSolutions.add(this.solveSlot(slot, slotsAssignmentProblem));
        }
        FixedSlotsAssignmentSolution slotsSolution = DefaultFixedSlotsAssignmentSolution.create(slotSolutions);
        LOGGER.debug("done solving fixed slot problems", new Object[0]);
        return slotsSolution;
    }

    private FixedSlotItemsSolution solveSlot(IWorkSlot workSlot, IFixedSlotsAssignmentProblem slotsAssignmentProblem) {
        PeriodAssignmentProblemTransformationResult transformationResult = this.transformer.transform(workSlot, slotsAssignmentProblem);
        OverbookedPeriodAssignmentSolution periodAssignmentSolution = this.solver.solve(transformationResult.getProblem());
        return this.retransformer.retransform(transformationResult, periodAssignmentSolution);
    }
}

