/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.ActivityResourceSkillVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.OverbookedPeriodAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.PeriodAssignmentProblem;
import java.util.Map;

public class DefaultOverbookedPeriodAssignmentSolution
implements OverbookedPeriodAssignmentSolution {
    private final float[][][] assignments;
    private final PeriodAssignmentProblem problem;

    private DefaultOverbookedPeriodAssignmentSolution(float[][][] assignments, PeriodAssignmentProblem problem) {
        this.assignments = assignments;
        this.problem = problem;
    }

    public static OverbookedPeriodAssignmentSolution create(Map<ActivityResourceSkillVariable, Float> assignments, PeriodAssignmentProblem problem) {
        float[][][] array = new float[problem.getActivities()][problem.getResources()][problem.getSkills()];
        for (Map.Entry<ActivityResourceSkillVariable, Float> entry : assignments.entrySet()) {
            array[entry.getKey().getActivity()][entry.getKey().getResource()][entry.getKey().getSkill()] = entry.getValue().floatValue();
        }
        return new DefaultOverbookedPeriodAssignmentSolution(array, problem);
    }

    @Override
    public float getAssignedWork(int a, int r, int s) {
        return this.assignments[a][r][s];
    }

    @Override
    public float getAssignedWorkForResource(int resource) {
        float sum = 0.0f;
        for (int a = 0; a < this.assignments.length; ++a) {
            for (int s = 0; s < this.assignments[0][0].length; ++s) {
                sum += this.assignments[a][resource][s];
            }
        }
        return sum;
    }

    @Override
    public boolean isOverbooked() {
        for (int r = 0; r < this.assignments[0].length; ++r) {
            float resourceWork = this.getAssignedWorkForResource(r);
            if (!(resourceWork > this.problem.getAvailability(r))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getActivities() {
        return this.problem.getActivities();
    }

    @Override
    public int getResources() {
        return this.problem.getResources();
    }

    @Override
    public int getSkills() {
        return this.problem.getSkills();
    }

    @Override
    public boolean isActivityScheduled(int activity) {
        for (int s = 0; s < this.problem.getSkills(); ++s) {
            if (!(this.getActivitySkillSum(activity, s) + 0.01f < this.problem.getDemand(activity, s))) continue;
            return false;
        }
        return true;
    }

    private float getActivitySkillSum(int activity, int s) {
        float sum = 0.0f;
        for (int r = 0; r < this.getResources(); ++r) {
            sum += this.getAssignedWork(activity, r, s);
        }
        return sum;
    }
}

