/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotItemsSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotItemsSolutionMapImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.DecisionVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.DistributeOverbookProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotWorkAssignmentImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.MaximizeWorkProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.OverbookedWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.ComplexityViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SolutionCreator {
    SolutionCreator() {
    }

    static FixedSlotItemsSolution createTooComplexViolationSolution(MaximizeWorkProblem problem) {
        HashSet complexityViolation = Sets.newHashSet();
        for (IProcessingItem item : problem.getItems()) {
            complexityViolation.add(new ComplexityViolation(item.getId()));
        }
        HashMap assignmentMap = Maps.newHashMap();
        for (IProcessingItem item : problem.getItems()) {
            assignmentMap.put(item, Sets.newHashSet());
        }
        return new FixedSlotItemsSolutionMapImpl(problem.getWorkSlot(), assignmentMap, Sets.newHashSet(), complexityViolation);
    }

    static Optional<FixedSlotItemsSolution> tryCreateCompleteSolution(MaximizeWorkProblem problem, float[] solution) {
        if (problem.isCompleteSolution(solution)) {
            return Optional.of((Object)new FixedSlotItemsSolutionMapImpl(problem.getWorkSlot(), SolutionCreator.getWorkAssignmentMap(problem.getWorkDecisionVariables(), solution, problem.getWorkSlot()), Sets.newHashSet(), Sets.newHashSet()));
        }
        return Optional.absent();
    }

    static FixedSlotItemsSolutionMapImpl create(DistributeOverbookProblem problem, float[] solution) {
        return new FixedSlotItemsSolutionMapImpl(problem.getWorkSlot(), SolutionCreator.getWorkAssignmentMap(problem.getWorkDecisionVariables(), solution, problem.getWorkSlot()), SolutionCreator.createWarningsForAllItems(problem.getItems()), Sets.newHashSet());
    }

    private static Map<IProcessingItem, Set<FixedSlotWorkAssignment>> getWorkAssignmentMap(Collection<DecisionVariable> decisionVariables, float[] solution, IWorkSlot workSlot) {
        HashMap assignmentMap = Maps.newHashMap();
        for (DecisionVariable itemVar : decisionVariables) {
            if (solution[itemVar.getIndex()] < 0.01f) continue;
            RmUtils.addToKeyedSets(assignmentMap, itemVar.getProcessingItem(), new FixedSlotWorkAssignmentImpl(itemVar, workSlot, solution[itemVar.getIndex()]));
        }
        return assignmentMap;
    }

    private static Set<IScheduleWarning> createWarningsForAllItems(List<IProcessingItem> items) {
        HashSet warnings = Sets.newHashSet();
        for (IProcessingItem item : items) {
            warnings.add(new OverbookedWarning(item.getId()));
        }
        return warnings;
    }
}

