/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.AbstractItemSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IUnstructuredItemSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IRoadmapProblemStatistics;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IUnstructuredItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ProcessingItemType;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import java.util.Set;

public class UnstructuredItemSchedulingProblem
extends AbstractItemSchedulingProblem
implements IUnstructuredItemSchedulingProblem {
    private static final Log LOGGER = Log.with(UnstructuredItemSchedulingProblem.class);
    private final IUnstructuredItem unstructuredItem;
    private final float minWorkUnitsPerTeamInWorkSlot;
    private final int itemReleaseTime;

    UnstructuredItemSchedulingProblem(IUnstructuredItem unstructuredItem, Set<IMutableResourcePool> availableResourcePools, int lowerTimeBound, int upperTimeBound, IRoadmapProblemStatistics projectStatistics, float minWorkUnitsPerTeamInWorkSlot, boolean stageTransitionEnforced, int itemReleaseTime, IEpisode legacyProjectEpisode, boolean enforced, boolean planningHorizonReached) {
        super(unstructuredItem.getId(), lowerTimeBound, upperTimeBound, availableResourcePools, projectStatistics, stageTransitionEnforced, legacyProjectEpisode, enforced, planningHorizonReached);
        this.unstructuredItem = unstructuredItem;
        this.minWorkUnitsPerTeamInWorkSlot = minWorkUnitsPerTeamInWorkSlot;
        this.itemReleaseTime = itemReleaseTime;
    }

    @Override
    public IAggregatedWorkPackage getWorkDemand() {
        return this.unstructuredItem.getWorkDemand();
    }

    @Override
    public float getMinWorkUnitsPerTeamInWorkSlot() {
        return this.minWorkUnitsPerTeamInWorkSlot;
    }

    @Override
    public int getCausalReleaseTime() {
        return this.itemReleaseTime;
    }

    @Override
    public ProcessingItemType getProcessingItemType() {
        return ProcessingItemType.Unstructured;
    }

    @Override
    public IProcessingItem getProcessingItem() {
        return this.unstructuredItem;
    }

    public static IUnstructuredItemSchedulingProblem createInstance(IItemAssignmentProblem assignmentProblem, Set<IMutableResourceGroup> mutableResourceGroups, IRoadmapProblem problem) {
        int problemLowerTimeBound = Math.max(assignmentProblem.getCausalReleaseTime(), assignmentProblem.getLowerTimeBound());
        IRoadmapProblemStatistics stats = problem.getRoadmapStatistics();
        float minLoadPerSprint = problem.getProcessingDefinition().getMinLoadPerSprint();
        Set<IMutableResourcePool> availableResourcePools = assignmentProblem.getProcessingItem().getAssignmentRestriction().filterMutableResourcePools(mutableResourceGroups);
        boolean stageTransitionEnforced = problem.getProcessingDefinition().isStageTransitionEnforced();
        boolean schedulingEnforced = assignmentProblem.isSchedulingEnforced();
        UnstructuredItemSchedulingProblem instance = new UnstructuredItemSchedulingProblem((IUnstructuredItem)assignmentProblem.getProcessingItem(), availableResourcePools, problemLowerTimeBound, assignmentProblem.getUpperTimeBound(), stats, minLoadPerSprint, stageTransitionEnforced, assignmentProblem.getCausalReleaseTime(), assignmentProblem.getProjectEpisode(), schedulingEnforced, assignmentProblem.isUpperTimeBoundPlanningHorizon());
        LogUtil.debug(LOGGER, "created: %s", instance);
        return instance;
    }
}

