/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IResourceToTypeWeightVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.IUnstructuredStageLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PrimitivesMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnstructuredStageLpProblem
implements IUnstructuredStageLpProblem {
    private final List<IResourceToTypeWeightVariable> vars;
    private final Map<IResourceType, Set<Integer>> typeIndices;
    private final float minWorkLoad;
    private final PositivePrimitivesMap<IResourceType> typeLimits;
    private final String itemId;
    private final float maxWorkLoad;
    private final IEpisode episode;
    private final Map<IMutableResource, Set<Integer>> resourceIndices;
    private final PositivePrimitivesMap<IMutableResource> availabilityLimits;
    private final PrimitivesMap<IMutableResource> resourceCost;

    UnstructuredStageLpProblem(String itemId, List<IResourceToTypeWeightVariable> vars, Map<IMutableResource, Set<Integer>> resourceIndices, Map<IResourceType, Set<Integer>> typeIndices, float minWorkLoad, float maxWorkLoad, PositivePrimitivesMap<IResourceType> typeLimits, PositivePrimitivesMap<IMutableResource> availabilityLimits, PrimitivesMap<IMutableResource> resourceCost, IEpisode episode) {
        this.vars = vars;
        this.itemId = itemId;
        this.resourceIndices = resourceIndices;
        this.typeIndices = typeIndices;
        this.minWorkLoad = minWorkLoad;
        this.typeLimits = typeLimits;
        this.availabilityLimits = availabilityLimits;
        this.resourceCost = resourceCost;
        this.maxWorkLoad = maxWorkLoad;
        this.episode = episode;
    }

    @Override
    public IResourceToTypeWeightVariable getAssignmentVariable(int i) {
        return this.vars.get(i);
    }

    @Override
    public List<IResourceToTypeWeightVariable> getAssignmentVariables() {
        return this.vars;
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getResourceTypeLimits() {
        return this.typeLimits;
    }

    @Override
    public PositivePrimitivesMap<IMutableResource> getWorkResourceLimits() {
        return this.availabilityLimits;
    }

    @Override
    public Set<Integer> getIndicesForWorkResource(IMutableResource workResource) {
        return this.resourceIndices.get(workResource);
    }

    @Override
    public Set<Integer> getIndicesForResourceType(IResourceType resourceType) {
        return this.typeIndices.get(resourceType);
    }

    @Override
    public float getMinWorkLoad() {
        return this.minWorkLoad;
    }

    @Override
    public String getId() {
        return this.itemId;
    }

    @Override
    public int getVariableCount() {
        return this.vars.size();
    }

    @Override
    public PrimitivesMap<IMutableResource> getResourceCost() {
        return this.resourceCost;
    }

    @Override
    public Map<IResourceType, Set<Integer>> getResourceTypeIndices() {
        return this.typeIndices;
    }

    @Override
    public Map<IMutableResource, Set<Integer>> getWorkResourceIndices() {
        return this.resourceIndices;
    }

    @Override
    public float getMaxWorkLoad() {
        return this.maxWorkLoad;
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.typeIndices.keySet();
    }

    @Override
    public IEpisode getProjectEpisode() {
        return this.episode;
    }
}

