/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ResourceType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public class ProcessingStage
implements IProcessingStage {
    public static final String DUMMY_ID = "default";
    public static final IProcessingStage DUMMY_STAGE = new ProcessingStage("default", Sets.newHashSet((Object[])new IResourceType[]{ResourceType.DUMMY_TYPE}), 1.0f, 0, "default", "0");
    private final String id;
    private final Set<IResourceType> resourceTypes;
    private final float defaultPercentage;
    private final int index;
    private final String title;
    private final String sortKey;

    public ProcessingStage(String id, Set<IResourceType> resourceTypes, float defaultPercentage, int index, String title, String sortKey) {
        Preconditions.checkNotNull((Object)id, (Object)"ID must not be null");
        Preconditions.checkNotNull((Object)sortKey, (Object)"sort key must not be null");
        this.id = id;
        this.resourceTypes = Collections.unmodifiableSet(resourceTypes);
        this.defaultPercentage = defaultPercentage;
        this.index = index;
        this.title = title;
        this.sortKey = sortKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public float getDefaultPercentage() {
        return this.defaultPercentage;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.id).toHashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingStage)) {
            return false;
        }
        ProcessingStage other = (ProcessingStage)obj;
        return new EqualsBuilder().append(this.id, other.id).isEquals();
    }

    public String toString() {
        return "ProcessingStage [id=" + this.id + ", index=" + this.index + ", title=" + this.title + "]";
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }
}

