/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivitySet;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ActivitySetSchedule
implements IActivitySetSchedule {
    private final IIntegerInterval activeInterval;
    private final IActivitySet activitySet;
    private final Set<IActivitySchedule> activitySchedules;
    private final IResourceGroup resourceGroup;
    private final Set<IScheduleWarning> warnings;
    private final int releaseTime;

    ActivitySetSchedule(IActivitySet activitySet, IResourceGroup resourceGroup, IIntegerInterval activeInterval, Set<IActivitySchedule> activitySchedules, Set<IScheduleWarning> warnings, int releaseTime) {
        this.activitySet = activitySet;
        this.resourceGroup = resourceGroup;
        this.activeInterval = activeInterval;
        this.activitySchedules = Collections.unmodifiableSet(activitySchedules);
        this.warnings = Collections.unmodifiableSet(warnings);
        this.releaseTime = releaseTime;
    }

    @Override
    public int getEnd() {
        return this.activeInterval.getEnd();
    }

    @Override
    public int getStart() {
        return this.activeInterval.getStart();
    }

    @Override
    public String getId() {
        return this.activitySet.getId();
    }

    @Override
    public Set<IActivitySchedule> getActivitySchedules() {
        return this.activitySchedules;
    }

    @Override
    public IActivitySet getActivitySet() {
        return this.activitySet;
    }

    @Override
    public IResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    @Override
    public Set<IScheduleWarning> getWarnings() {
        return this.warnings;
    }

    @Override
    public int getLength() {
        return this.activeInterval.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.activeInterval.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.activeInterval.getOverlappingInterval(interval);
    }

    @Override
    public Set<IWorkAssignment> getWorkAssignments() {
        return RmSchedulingUtils.getWorkAssignments(this.activitySchedules);
    }

    @Override
    public int getReleaseTime() {
        return this.releaseTime;
    }

    public static ActivitySetSchedule createSchedule(IActivitySet activitySet, IResourceGroup resourceGroup, Set<IActivitySchedule> activitySchedules, Set<IScheduleWarning> warnings, int releaseTime) {
        Preconditions.checkNotNull((Object)activitySet, (Object)"activity set must not be null");
        Preconditions.checkNotNull((Object)resourceGroup, (Object)"resource group definition must not be null");
        Preconditions.checkNotNull(activitySchedules, (Object)"activity schedule set must not be null");
        Preconditions.checkNotNull(warnings, (Object)"warning set must not be null");
        IIntegerInterval interval = RmUtils.getMergedIntervals(activitySchedules);
        ActivitySetSchedule instance = new ActivitySetSchedule(activitySet, resourceGroup, interval, activitySchedules, warnings, releaseTime);
        return instance;
    }
}

