/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.IGroupActivitySchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ISingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.WorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentProblemSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.TemporalResourceAssignment;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

public class SingleResourceGroupAssignment
implements ISingleResourceGroupAssignment {
    private static final Log LOGGER = Log.with(SingleResourceGroupAssignment.class);
    private final Set<IWorkAssignment> assignments;
    private final IIntegerInterval activeInterval;
    private final Set<IWorkSlot> workSlots;

    private SingleResourceGroupAssignment(Set<IWorkAssignment> assignments, IIntegerInterval activeInterval, Set<IWorkSlot> workSlots) {
        this.assignments = assignments;
        this.activeInterval = activeInterval;
        this.workSlots = workSlots;
    }

    @Override
    public int getEnd() {
        return this.activeInterval.getEnd();
    }

    @Override
    public int getStart() {
        return this.activeInterval.getStart();
    }

    @Override
    public Set<IWorkAssignment> getWorkAssignments() {
        return this.assignments;
    }

    @Override
    public int getLength() {
        return this.activeInterval.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.activeInterval.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.activeInterval.getOverlappingInterval(interval);
    }

    @Override
    public Set<IWorkSlot> getUsedWorkSlots() {
        return this.workSlots;
    }

    public static Optional<ISingleResourceGroupAssignment> tryCreateInstance(Set<IWorkAssignment> workAssignments) {
        LogUtil.debugCollection(LOGGER, "try create for work assignments: %s", workAssignments);
        if (workAssignments.isEmpty()) {
            LogUtil.debug(LOGGER, "no work assignments");
            return Optional.absent();
        }
        IIntegerInterval interval = RmUtils.getMergedIntervals(workAssignments);
        HashSet slots = Sets.newHashSet();
        for (IWorkAssignment assignment : workAssignments) {
            slots.add(assignment.getWorkSlot());
        }
        SingleResourceGroupAssignment instance = new SingleResourceGroupAssignment(workAssignments, interval, slots);
        LogUtil.debug(LOGGER, "created instancce: %s", instance);
        return Optional.of((Object)instance);
    }

    public static SingleResourceGroupAssignment merge(ISingleResourceGroupAssignment assignment1, ISingleResourceGroupAssignment assignment2) {
        Set<IWorkAssignment> mergedAssignments = RmCollectionUtils.createMergedSet(assignment1.getWorkAssignments(), assignment2.getWorkAssignments());
        IntegerInterval mergedInterval = new IntegerInterval(Math.min(assignment1.getStart(), assignment2.getStart()), Math.max(assignment1.getEnd(), assignment2.getEnd()));
        Set<IWorkSlot> mergedWorkSlots = RmCollectionUtils.createMergedSet(assignment1.getUsedWorkSlots(), assignment2.getUsedWorkSlots());
        SingleResourceGroupAssignment merged = new SingleResourceGroupAssignment(mergedAssignments, mergedInterval, mergedWorkSlots);
        return merged;
    }

    public static ISingleResourceGroupAssignment createInstanceFromAssignment(AssignmentProblemSolution solution, IGroupActivitySchedulingProblem problem) {
        Set<TemporalResourceAssignment> assignments = solution.getAssignments();
        HashSet workAssignments = Sets.newHashSet();
        Set<String> subTaskIds = RmIdentifiableUtils.getIds(problem.getActivity().getStageTasks());
        IMutableResourceGroup resourceGroup = problem.getResourceGroup();
        IProcessingStage stage = problem.getActivity().getProcessingStage();
        for (TemporalResourceAssignment assignment : assignments) {
            IWorkResource workResource = problem.getResource(assignment.getResource().getId());
            String itemId = problem.getItemId();
            if (subTaskIds.contains(assignment.getId())) {
                itemId = assignment.getId();
            }
            WorkAssignment workAssignment = new WorkAssignment(itemId, resourceGroup.getWorkSlotWithIndex(assignment.getTimeIndex()), stage, resourceGroup, workResource, problem.getType(assignment.getTypeId().getId()), assignment.getValue(), problem.getProjectEpisode());
            workAssignments.add(workAssignment);
        }
        return (ISingleResourceGroupAssignment)SingleResourceGroupAssignment.tryCreateInstance(workAssignments).get();
    }
}

