/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisodeStream;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PreorderedEpisodeStream
implements IEpisodeStream {
    private final String id;
    private final List<IEpisode> episodes;
    private final Set<String> assignableGroupIds;
    private final Map<String, Set<String>> prerequisitesMap;

    public static PreorderedEpisodeStream construct(String id, List<IEpisode> episodes, Set<String> assignableGroupIds) {
        return new PreorderedEpisodeStream(id, episodes, assignableGroupIds, PreorderedEpisodeStream.initPrerequisitesMap(episodes));
    }

    private PreorderedEpisodeStream(String id, List<IEpisode> episodes, Set<String> assignableGroupIds, Map<String, Set<String>> prerequisitesMap) {
        Preconditions.checkNotNull(episodes, (Object)"list of episodes must not be null");
        Preconditions.checkArgument((!episodes.isEmpty() ? 1 : 0) != 0, (Object)"list if episodes must not be empty");
        Preconditions.checkArgument((boolean)episodes.get(0).getFixedStartTime().isPresent(), (Object)"first episode must have start time");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id must not be null");
        this.episodes = Collections.unmodifiableList(episodes);
        this.assignableGroupIds = Collections.unmodifiableSet((Set)Preconditions.checkNotNull(assignableGroupIds, (Object)"set of assignable group IDs must not be null"));
        this.prerequisitesMap = prerequisitesMap;
    }

    private static Map<String, Set<String>> initPrerequisitesMap(List<IEpisode> episodes) {
        Preconditions.checkNotNull(episodes, (Object)"list of episodes must not be null");
        HashMap prerequisites = Maps.newHashMap();
        HashSet aggregatedPrerequisites = Sets.newHashSet();
        for (IEpisode episode : episodes) {
            if (episode.getFixedStartTime().isPresent()) {
                aggregatedPrerequisites.clear();
            }
            prerequisites.put(episode.getId(), Sets.newHashSet((Iterable)aggregatedPrerequisites));
            aggregatedPrerequisites.add(episode.getId());
        }
        return prerequisites;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<IEpisode> getEpisodes() {
        return this.episodes;
    }

    @Override
    public Set<String> getAssignableGroupIds() {
        return this.assignableGroupIds;
    }

    @Override
    public IEpisode getEpisode(final String episodeId) {
        return (IEpisode)Iterables.find(this.episodes, (Predicate)new Predicate<IEpisode>(){

            public boolean apply(@Nullable IEpisode episode) {
                return episodeId.equals(episode.getId());
            }
        });
    }

    @Override
    public boolean isEpisodeStrictlyBefore(String episodeId1, String episodeId2) {
        return this.prerequisitesMap.containsKey(episodeId2) && this.prerequisitesMap.get(episodeId2).contains(episodeId1);
    }

    @Override
    public IEpisode getLatestEpisode() {
        return this.episodes.get(this.episodes.size() - 1);
    }

    public String toString() {
        return "PreorderedEpisodeStream [id=" + this.id + ", episodes=" + Joiner.on((String)",").join(this.episodes) + "]";
    }
}

