/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.TimePlanRestriction;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EpisodeRestriction
implements TimePlanRestriction {
    private final IEpisode strictEpisode;

    public EpisodeRestriction(IEpisode strictEpisode) {
        Preconditions.checkNotNull((Object)strictEpisode, (Object)"episode must not be null");
        this.strictEpisode = strictEpisode;
    }

    @Override
    public String getStreamId() {
        return this.strictEpisode.getStreamId();
    }

    @Override
    public Optional<String> getFixedEpisodeId() {
        return Optional.of((Object)this.strictEpisode.getId());
    }

    @Override
    public Optional<IEpisode> getFixedEpisode() {
        return Optional.of((Object)this.strictEpisode);
    }

    @Override
    public boolean isStrictlyAssigned() {
        return true;
    }

    @Override
    public List<IEpisode> getPossibleEpisodes() {
        return Lists.newArrayList((Object[])new IEpisode[]{this.strictEpisode});
    }
}

