/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.ImmutableAssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.SubAssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AssignmentCandidateFactory {
    private static final Log LOGGER = Log.with(ImmutableAssignmentCandidate.class);

    public AssignmentCandidate createAddTime(AssignmentCandidate candidate, BoundAssignmentProblem problem) {
        int addTime = candidate.getLatestTime() + 1;
        ArrayList times = Lists.newArrayList(candidate.getTimeIndices());
        times.add(addTime);
        MutablePositivePrimitivesMap<AssignmentResource> availabilities = RmCollectionUtils.newMutablePositiveMap(candidate.getAggregatedAvailabilities());
        for (AssignmentResource resource : candidate.getResourceCosts().keySet()) {
            availabilities.add(resource, resource.getUnassignedWorkInWorkSlot(addTime));
        }
        ImmutableAssignmentCandidate instance = new ImmutableAssignmentCandidate(candidate.getSubAssignmentCandidates(), times, candidate.getResourceCosts(), availabilities, candidate.getSortKey(), candidate.isSyncStart(), problem.getOverallDemand());
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return instance;
    }

    static ImmutableAssignmentCandidate createInstance(List<SubAssignmentCandidate> subAssignmentCandidates, int time, BoundAssignmentProblem problem) throws InterruptedException {
        Set<AssignmentResource> allResources = AssignmentCandidateFactory.getAllResources(subAssignmentCandidates);
        LogUtil.debug(LOGGER, "create instance for combination %s and time %s", allResources, time);
        ArrayList times = Lists.newArrayList((Object[])new Integer[]{time});
        MutablePositivePrimitivesMap<AssignmentResource> availabilities = RmCollectionUtils.newMutablePositiveMap(allResources.size());
        for (AssignmentResource resource : allResources) {
            float availability = resource.getUnassignedWorkInWorkSlot(time);
            if (!((double)availability > 0.0)) continue;
            availabilities.put(resource, availability);
        }
        ImmutableAssignmentCandidate instance = new ImmutableAssignmentCandidate(subAssignmentCandidates, times, AssignmentCandidateFactory.getResourceCosts(allResources), availabilities, AssignmentCandidateFactory.createSortKey(subAssignmentCandidates), problem.isSyncStart(), problem.getOverallDemand());
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return instance;
    }

    private static PrimitivesMap<AssignmentResource> getResourceCosts(Set<AssignmentResource> resources) {
        MutablePrimitivesMap<AssignmentResource> resourceCosts = RmCollectionUtils.newMutableMap(resources.size());
        for (AssignmentResource resource : resources) {
            resourceCosts.put(resource, resource.getCost());
        }
        return resourceCosts;
    }

    private static Set<AssignmentResource> getAllResources(Iterable<SubAssignmentCandidate> subAssignmentCandidates) {
        HashSet allResources = Sets.newHashSet();
        for (SubAssignmentCandidate subAssignmentCandidate : subAssignmentCandidates) {
            allResources.addAll(subAssignmentCandidate.getCombination());
        }
        return allResources;
    }

    private static String createSortKey(List<SubAssignmentCandidate> combination) {
        StringBuilder sortKey = new StringBuilder("");
        for (SubAssignmentCandidate subCombination : combination) {
            for (AssignmentResource assignmentResource : RmSortableUtils.sort(subCombination.getCombination())) {
                sortKey.append(assignmentResource.getSortKey()).append("@");
            }
            sortKey.append("@");
        }
        return sortKey.toString();
    }
}

