/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class GreedyTypeSampling {
    private final Random tieBreaker;

    public GreedyTypeSampling() {
        this.tieBreaker = new Random(12331L);
    }

    GreedyTypeSampling(Random random) {
        this.tieBreaker = random;
    }

    public Optional<AssignmentResource> sample(List<AssignmentResource> pool, Set<IResourceType> needed) {
        if (pool.isEmpty()) {
            return Optional.absent();
        }
        int maxTypeCount = 0;
        AssignmentResource maxResource = null;
        for (AssignmentResource resource : pool) {
            int typeCount = Sets.intersection(needed, resource.getTypes()).size();
            if (typeCount > maxTypeCount) {
                maxResource = resource;
                maxTypeCount = typeCount;
            }
            if (typeCount != maxTypeCount || maxResource != null && !this.tieBreaker.nextBoolean()) continue;
            maxResource = resource;
        }
        return Optional.of(maxResource);
    }
}

