/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpAssignmentVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpSolutionImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.UnweightedAssignmentLpProblem;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.math3.optim.PointValuePair;

@Immutable
class ApacheSolutionCreator {
    private static final Log LOGGER = Log.with(ApacheSolutionCreator.class);

    ApacheSolutionCreator() {
    }

    LpSolution create(PointValuePair optSolution, UnweightedAssignmentLpProblem problem) {
        Preconditions.checkNotNull((Object)optSolution, (Object)"solution must not be null");
        Preconditions.checkNotNull((Object)problem, (Object)"problem must not be null");
        LogUtil.debug(LOGGER, "create solution for: %s", optSolution);
        float[] assignmentArray = RmUtils.toFloatArray((double[])optSolution.getFirst());
        LogUtil.debug(LOGGER, "\nLP solution: " + Arrays.toString(assignmentArray));
        List<LpAssignmentVariable> variables = problem.getVariables();
        Preconditions.checkArgument((assignmentArray.length == variables.size() ? 1 : 0) != 0, (Object)"incompatible assignments");
        MutablePositivePrimitivesMap<LpAssignmentVariable> mutableMap = RmCollectionUtils.newMutablePositiveMap(variables.size());
        for (int i = 0; i < variables.size(); ++i) {
            LpAssignmentVariable variable = variables.get(i);
            mutableMap.put(variable, assignmentArray[i]);
        }
        LpSolutionImpl instance = new LpSolutionImpl(mutableMap);
        LogUtil.debug(LOGGER, "created solution: %s", instance);
        return instance;
    }
}

