/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class RmUtils {
    private static final Log LOGGER = Log.with(RmUtils.class);
    private static final int PRECISION = 1;

    private RmUtils() {
    }

    public static <K1, K2, V> void addToKeyedMaps(Map<K1, Map<K2, V>> mapping, K1 key1, K2 key2, V value) {
        if (mapping.containsKey(key1)) {
            mapping.get(key1).put(key2, value);
        } else {
            HashMap newMap = Maps.newHashMap();
            newMap.put(key2, value);
            mapping.put(key1, newMap);
        }
    }

    public static <T, K> Map<K, Set<T>> getPartitions(Set<T> elements, Function<T, K> assignmentFunction) {
        Preconditions.checkNotNull(elements, (Object)"element set must not be null");
        Preconditions.checkNotNull(assignmentFunction, (Object)"assignmentFunction must not be null");
        HashMap partitions = Maps.newHashMap();
        for (T element : elements) {
            Object key = assignmentFunction.apply(element);
            if (key != null) {
                RmUtils.addToKeyedSets(partitions, key, element);
                continue;
            }
            LogUtil.debug(LOGGER, "assignment function delivered null key for element: %s", element);
        }
        return partitions;
    }

    public static <K, V> Map.Entry<K, V> createEntry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K> boolean hasGeqMinEntry(Map<K, Float> map) {
        Preconditions.checkNotNull(map, (Object)"map to check must not be null");
        for (Float value : map.values()) {
            if (value == null || !(value.floatValue() >= 0.01f)) continue;
            return true;
        }
        return false;
    }

    public static float[] round(float[] lpSolution) {
        float[] rounded = new float[lpSolution.length];
        for (int i = 0; i < lpSolution.length; ++i) {
            rounded[i] = RmUtils.round(lpSolution[i]);
        }
        return rounded;
    }

    private static float round(float unrounded) {
        BigDecimal bd = new BigDecimal(unrounded);
        BigDecimal rounded = bd.setScale(1, 4);
        return rounded.floatValue();
    }

    public static <T> Set<T> mergeToSet(Collection<? extends Collection<T>> collections) {
        HashSet all = Sets.newHashSet();
        for (Collection<T> collection : collections) {
            all.addAll(collection);
        }
        return all;
    }

    public static Set<Integer> getNonZeroIndices(float[] array) {
        Preconditions.checkNotNull((Object)array, (Object)"input array must not be null");
        HashSet indices = Sets.newHashSet();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0.0f) continue;
            indices.add(i);
        }
        return indices;
    }

    public static float sumDoubles(Iterable<Double> values) {
        Preconditions.checkNotNull(values, (Object)"value collection must not be null");
        float sum = 0.0f;
        for (Double value : values) {
            if (value == null) continue;
            sum += value.floatValue();
        }
        return sum;
    }

    public static float sumDoubles(double[] values) {
        float sum = 0.0f;
        for (double value : values) {
            sum += (float)value;
        }
        return sum;
    }

    public static <K, V> String toString(Map<K, V> map) {
        Preconditions.checkNotNull(map, (Object)"map to join must not be null");
        return Joiner.on((String)"&").withKeyValueSeparator("=").join(map);
    }

    public static <K> void addDoublesKeywise(Map<K, Double> map, K key, double value) {
        if (map.containsKey(key)) {
            double newValue = map.get(key) + value;
            map.put(key, newValue);
        } else {
            map.put(key, value);
        }
    }

    public static <K> void addFloatsKeywise(Map<K, Float> map, K key, float value) {
        if (map.containsKey(key)) {
            float newValue = map.get(key).floatValue() + value;
            map.put(key, Float.valueOf(newValue));
        } else {
            map.put(key, Float.valueOf(value));
        }
    }

    public static <K, V> boolean addToKeyedSets(Map<K, Set<V>> map, K key, V value) {
        if (map.containsKey(key)) {
            return map.get(key).add(value);
        }
        HashSet newSet = Sets.newHashSet();
        boolean contained = newSet.add(value);
        map.put(key, newSet);
        return contained;
    }

    public static <K, V> boolean addToKeyedLists(Map<K, List<V>> map, K key, V value) {
        if (map.containsKey(key)) {
            return map.get(key).add(value);
        }
        ArrayList newSet = Lists.newArrayList();
        boolean contained = newSet.add(value);
        map.put(key, newSet);
        return contained;
    }

    public static <T extends IIntegerInterval> IIntegerInterval getMergedIntervals(Collection<T> intervals) {
        Preconditions.checkNotNull(intervals, (Object)"interval collection must not be null");
        if (intervals.size() == 0) {
            return IntegerInterval.EMPTY;
        }
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (IIntegerInterval interval : intervals) {
            start = Math.min(start, interval.getStart());
            end = Math.max(end, interval.getEnd());
        }
        IntegerInterval newInterval = new IntegerInterval(start, end);
        return newInterval;
    }

    public static int getOptionalMax(int value, Optional<Integer> optionalValue) {
        if (!optionalValue.isPresent()) {
            return value;
        }
        return Math.max(value, (Integer)optionalValue.get());
    }

    public static long getOptionalMin(long value, Optional<Long> optionalValue) {
        if (!optionalValue.isPresent()) {
            return value;
        }
        return Math.min(value, (Long)optionalValue.get());
    }

    public static Optional<Long> getOptionalMin(Optional<Long> value1, Optional<Long> value2) {
        if (!value1.isPresent() && !value2.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)Math.min((Long)value1.or((Object)Long.MAX_VALUE), (Long)value2.or((Object)Long.MAX_VALUE)));
    }

    public static <T> boolean isUnequalToOptional(T object, Optional<T> optionalObject) {
        Preconditions.checkNotNull(object, (Object)"object must not be null");
        if (optionalObject.isPresent()) {
            return !object.equals(optionalObject.get());
        }
        return true;
    }

    public static <T> List<T> getReverseOrderWithNumericalValues(final PositivePrimitivesMap<T> map) {
        ArrayList ordered = Lists.newArrayList(map.keySet());
        Collections.sort(ordered, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Doubles.compare((double)map.get(o2), (double)map.get(o1));
            }
        });
        return ordered;
    }

    public static <T1 extends IIntegerInterval, T2 extends IIntegerInterval> Set<T2> getContainedIntervals(T1 baseInterval, Set<T2> intervals) {
        final int baseEnd = baseInterval.getEnd();
        final int baseStart = baseInterval.getStart();
        HashSet intervalsInBaseInterval = Sets.newHashSet((Iterable)Sets.filter(intervals, (Predicate)new Predicate<T2>(){

            public boolean apply(T2 input) {
                if (input == null) {
                    LOGGER.error("found null reference", new Object[0]);
                    return false;
                }
                int inputEnd = input.getEnd();
                int inputStart = input.getStart();
                return inputEnd <= baseEnd && inputStart >= baseStart;
            }
        }));
        return intervalsInBaseInterval;
    }

    public static int getMaxEnd(Set<? extends IIntegerInterval> intervals) {
        Preconditions.checkNotNull(intervals, (Object)"interval set must not be null");
        Preconditions.checkArgument((!intervals.isEmpty() ? 1 : 0) != 0, (Object)"interval set must not be empty");
        int maxEnd = Integer.MIN_VALUE;
        for (IIntegerInterval iIntegerInterval : intervals) {
            maxEnd = Math.max(maxEnd, iIntegerInterval.getEnd());
        }
        return maxEnd;
    }

    public static int getMinStart(Set<? extends IIntegerInterval> intervals) {
        Preconditions.checkNotNull(intervals, (Object)"interval set must not be null");
        Preconditions.checkArgument((!intervals.isEmpty() ? 1 : 0) != 0, (Object)"interval set must not be empty");
        int minStart = Integer.MAX_VALUE;
        for (IIntegerInterval iIntegerInterval : intervals) {
            minStart = Math.min(minStart, iIntegerInterval.getStart());
        }
        return minStart;
    }

    public static void setCoefficientForIndices(Set<Integer> indices, float value, double[] coefficients) {
        Preconditions.checkNotNull(indices, (Object)"indices must not be null");
        Preconditions.checkNotNull((Object)coefficients, (Object)"coefficients array must not be null");
        for (int index : indices) {
            coefficients[index] = value;
        }
    }

    public static <K, V> Map<K, V> filterMapByKeys(Map<K, V> unfiltered, final Set<K> keySet) {
        Preconditions.checkNotNull(unfiltered, (Object)"input map must not be null");
        Preconditions.checkNotNull(keySet, (Object)"filter key set must not be null");
        return Maps.filterKeys(unfiltered, (Predicate)new Predicate<K>(){

            public boolean apply(K input) {
                return keySet.contains(input);
            }
        });
    }

    public static <T> Set<T> getMergedMutableSet(Collection<T> collection1, Collection<T> collection2) {
        Preconditions.checkNotNull(collection1, (Object)"collection must not be null");
        Preconditions.checkNotNull(collection2, (Object)"collection must not be null");
        HashSet union = Sets.newHashSet(collection1);
        union.addAll(collection2);
        return union;
    }

    public static <K, V> Map<K, V> filterMapByNullableKeys(Map<K, V> unfiltered, @Nullable Set<K> keySet) {
        if (keySet == null) {
            return Maps.newHashMap();
        }
        return RmUtils.filterMapByKeys(unfiltered, keySet);
    }

    public static Optional<Long> getOptionalSum(Long ... nullableSummands) {
        Preconditions.checkNotNull((Object)nullableSummands, (Object)"input must not be null");
        long sum = 0L;
        boolean nonNullFound = false;
        for (Long nullableSummand : nullableSummands) {
            if (nullableSummand == null) continue;
            sum += nullableSummand.longValue();
            nonNullFound = true;
        }
        if (!nonNullFound) {
            return Optional.absent();
        }
        return Optional.of((Object)sum);
    }

    public static boolean isAllFalse(boolean ... bools) {
        Preconditions.checkNotNull((Object)bools, (Object)"input must not be null");
        for (boolean bool : bools) {
            if (!bool) continue;
            return false;
        }
        return true;
    }

    public static float sum(float ... floats) {
        Preconditions.checkNotNull((Object)floats, (Object)"input must not be null");
        float sum = 0.0f;
        for (float value : floats) {
            sum += value;
        }
        return sum;
    }

    public static float[] toFloatArray(double[] doubles) {
        Preconditions.checkNotNull((Object)doubles, (Object)"input must not be null");
        float[] floats = new float[doubles.length];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = RmUtils.toFloat(doubles[i]);
        }
        return floats;
    }

    public static float toFloat(double v) {
        return (float)v;
    }

    public static Optional<Float> toOptionalFloat(Optional<Double> value) {
        if (value.isPresent()) {
            return Optional.of((Object)Float.valueOf(RmUtils.toFloat((Double)value.get())));
        }
        return Optional.absent();
    }

    public static Optional<String> getOptionalMax(Optional<String> value1, Optional<String> value2) {
        if (value1.isPresent() && value2.isPresent()) {
            if (((String)value1.get()).compareTo((String)value2.get()) >= 0) {
                return value1;
            }
            return value2;
        }
        if (value1.isPresent()) {
            return value1;
        }
        if (value2.isPresent()) {
            return value2;
        }
        return Optional.absent();
    }

    public static int toPositiveInt(long value) {
        if (value < 0L) {
            return 0;
        }
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)value;
    }

    public static <K, V> Map<K, List<V>> getListMapping(Map<K, ? extends Collection<V>> collectionMap) {
        HashMap mapping = Maps.newHashMap();
        for (Map.Entry<K, Collection<V>> entry : collectionMap.entrySet()) {
            mapping.put(entry.getKey(), Lists.newArrayList((Iterable)entry.getValue()));
        }
        return mapping;
    }
}

