/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.function;

import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IMutableDiscreteStepFunction;
import com.google.common.base.Optional;
import gnu.trove.list.array.TFloatArrayList;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StepFunctionTroveListImpl
implements IMutableDiscreteStepFunction {
    private final TFloatArrayList ys;

    StepFunctionTroveListImpl(TFloatArrayList ys) {
        this.ys = ys;
    }

    public StepFunctionTroveListImpl(float y) {
        this.ys = new TFloatArrayList();
        this.ys.add(y);
    }

    @Override
    public Optional<Integer> getXWhereYGeq(float value, int minX) {
        if (this.ys.size() <= minX) {
            if (this.ys.get(this.ys.size() - 1) >= value) {
                return Optional.of((Object)minX);
            }
            return Optional.absent();
        }
        for (int i = minX; i < this.ys.size(); ++i) {
            if (!(this.ys.get(i) >= value)) continue;
            return Optional.of((Object)i);
        }
        return Optional.absent();
    }

    @Override
    public Optional<Integer> getXWhereYLeq(float value, int minX) {
        if (this.ys.size() <= minX) {
            if (this.ys.get(this.ys.size() - 1) <= value) {
                return Optional.of((Object)minX);
            }
            return Optional.absent();
        }
        for (int i = minX; i < this.ys.size(); ++i) {
            if (!(this.ys.get(i) <= value)) continue;
            return Optional.of((Object)i);
        }
        return Optional.absent();
    }

    @Override
    public void addAt(int x, float value) {
        this.extendList(x + 1);
        float oldValue = this.ys.get(x);
        this.ys.set(x, oldValue + value);
    }

    @Override
    public void add(IIntegerInterval interval, float value) {
        int upper = interval.getEnd();
        int addValues = upper - this.ys.size() + 2;
        if (addValues > 0) {
            float lastValue = this.ys.get(this.ys.size() - 1);
            for (int i = 0; i < addValues; ++i) {
                this.ys.add(lastValue);
            }
        }
        for (int i = interval.getStart(); i <= upper; ++i) {
            this.ys.set(i, this.ys.get(i) + value);
        }
    }

    private void extendList(int upper) {
        float lastValue = this.ys.get(this.ys.size() - 1);
        for (int i = this.ys.size() - 1; i <= upper; ++i) {
            this.ys.add(lastValue);
        }
    }

    @Override
    public float getAt(int x) {
        this.extendList(x);
        return this.ys.get(x);
    }
}

