/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.graph;

import com.atlassian.rm.jpo.scheduling.util.graph.IDirectedEdge;
import com.google.common.base.Preconditions;

public class DirectedGraphEdge<T>
implements IDirectedEdge<T> {
    private final T source;
    private final T target;

    public DirectedGraphEdge(T source, T target) {
        Preconditions.checkNotNull(source);
        Preconditions.checkNotNull(target);
        this.source = source;
        this.target = target;
    }

    @Override
    public T getSource() {
        return this.source;
    }

    @Override
    public T getDepending() {
        return this.target;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectedGraphEdge)) {
            return false;
        }
        DirectedGraphEdge other = (DirectedGraphEdge)obj;
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public String toString() {
        return "[source=" + this.source + ", target=" + this.target + "]";
    }
}

