/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.ProjectableSQLQuery;
import com.mysema.query.sql.SQLListener;
import com.mysema.query.sql.SQLListenerContext;
import com.mysema.query.sql.SQLListenerContextImpl;
import com.mysema.query.sql.SQLListeners;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.sql.SQLResultIterator;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.ParamNotSetException;
import com.mysema.query.types.Path;
import com.mysema.util.ResultSetAdapter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSQLQuery<Q extends AbstractSQLQuery<Q>>
extends ProjectableSQLQuery<Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSQLQuery.class);
    private static final QueryFlag rowCountFlag = new QueryFlag(QueryFlag.Position.AFTER_PROJECTION, ", count(*) over() ");
    @Nullable
    private final Connection conn;
    protected SQLListeners listeners;
    protected boolean useLiterals;
    private boolean getLastCell;
    private Object lastCell;

    public AbstractSQLQuery(@Nullable Connection conn, Configuration configuration) {
        this(conn, configuration, new DefaultQueryMetadata().noValidate());
    }

    public AbstractSQLQuery(@Nullable Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(new QueryMixin(metadata, false), configuration);
        this.conn = conn;
        this.listeners = new SQLListeners(configuration.getListeners());
        this.useLiterals = configuration.getUseLiterals();
    }

    public void addListener(SQLListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public long count() {
        try {
            return this.unsafeCount();
        }
        catch (SQLException e) {
            String error = "Caught " + e.getClass().getName();
            logger.error(error, (Throwable)e);
            throw this.configuration.translate(e);
        }
    }

    public Q forUpdate() {
        return (Q)((AbstractSQLQuery)this.addFlag(SQLOps.FOR_UPDATE_FLAG));
    }

    @Override
    protected SQLSerializer createSerializer() {
        SQLSerializer serializer = new SQLSerializer(this.configuration);
        serializer.setUseLiterals(this.useLiterals);
        return serializer;
    }

    @Nullable
    private <T> T get(ResultSet rs, Expression<?> expr, int i, Class<T> type) throws SQLException {
        return this.configuration.get(rs, expr instanceof Path ? (Path)expr : null, i, type);
    }

    private void set(PreparedStatement stmt, Path<?> path, int i, Object value) throws SQLException {
        this.configuration.set(stmt, path, i, value);
    }

    protected SQLListenerContextImpl startContext(Connection connection, QueryMetadata metadata) {
        SQLListenerContextImpl context = new SQLListenerContextImpl(metadata, connection);
        this.listeners.start(context);
        return context;
    }

    protected void onException(SQLListenerContextImpl context, Exception e) {
        context.setException(e);
        this.listeners.exception(context);
    }

    protected void endContext(SQLListenerContext context) {
        this.listeners.end(context);
    }

    public ResultSet getResults(Expression<?> ... exprs) {
        this.queryMixin.addProjection(exprs);
        SQLListenerContextImpl context = this.startContext(this.conn, this.queryMixin.getMetadata());
        this.listeners.preRender(context);
        SQLSerializer serializer = this.serialize(false);
        String queryString = serializer.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("query : {}", (Object)queryString);
        }
        context.addSQL(queryString);
        this.listeners.rendered(context);
        this.listeners.notifyQuery(this.queryMixin.getMetadata());
        List<Object> constants = serializer.getConstants();
        try {
            this.listeners.prePrepare(context);
            final PreparedStatement stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, constants, serializer.getConstantPaths(), this.getMetadata().getParams());
            context.addPreparedStatement(stmt);
            this.listeners.prepared(context);
            this.listeners.preExecute(context);
            ResultSet rs = stmt.executeQuery();
            this.listeners.executed(context);
            ResultSetAdapter resultSetAdapter = new ResultSetAdapter(rs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws SQLException {
                    try {
                        super.close();
                    }
                    finally {
                        stmt.close();
                    }
                }
            };
            return resultSetAdapter;
        }
        catch (SQLException e) {
            this.onException(context, e);
            throw this.configuration.translate(queryString, constants, e);
        }
        finally {
            this.reset();
            this.endContext(context);
        }
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public <RT> CloseableIterator<RT> iterate(Expression<RT> expr) {
        expr = this.queryMixin.addProjection(expr);
        return this.iterateSingle(this.queryMixin.getMetadata(), expr);
    }

    private <RT> CloseableIterator<RT> iterateSingle(QueryMetadata metadata, final @Nullable Expression<RT> expr) {
        SQLListenerContextImpl context = this.startContext(this.conn, this.queryMixin.getMetadata());
        this.listeners.preRender(context);
        SQLSerializer serializer = this.serialize(false);
        String queryString = serializer.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("query : {}", (Object)queryString);
        }
        context.addSQL(queryString);
        this.listeners.rendered(context);
        this.listeners.notifyQuery(this.queryMixin.getMetadata());
        List<Object> constants = serializer.getConstants();
        try {
            this.listeners.prePrepare(context);
            PreparedStatement stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, constants, serializer.getConstantPaths(), metadata.getParams());
            context.addPreparedStatement(stmt);
            this.listeners.prepared(context);
            this.listeners.preExecute(context);
            ResultSet rs = stmt.executeQuery();
            this.listeners.executed(context);
            if (expr == null) {
                SQLResultIterator sQLResultIterator = new SQLResultIterator<RT>(this.configuration, stmt, rs){

                    @Override
                    public RT produceNext(ResultSet rs) throws Exception {
                        return rs.getObject(1);
                    }
                };
                return sQLResultIterator;
            }
            if (expr instanceof FactoryExpression) {
                SQLResultIterator sQLResultIterator = new SQLResultIterator<RT>(this.configuration, stmt, rs){

                    @Override
                    public RT produceNext(ResultSet rs) throws Exception {
                        return AbstractSQLQuery.this.newInstance((FactoryExpression)expr, rs, 0);
                    }
                };
                return sQLResultIterator;
            }
            if (expr.getType().isArray()) {
                SQLResultIterator sQLResultIterator = new SQLResultIterator<RT>(this.configuration, stmt, rs){

                    @Override
                    public RT produceNext(ResultSet rs) throws Exception {
                        Object[] rv = new Object[rs.getMetaData().getColumnCount()];
                        for (int i = 0; i < rv.length; ++i) {
                            rv[i] = rs.getObject(i + 1);
                        }
                        return rv;
                    }
                };
                return sQLResultIterator;
            }
            SQLResultIterator sQLResultIterator = new SQLResultIterator<RT>(this.configuration, stmt, rs){

                @Override
                public RT produceNext(ResultSet rs) throws Exception {
                    return AbstractSQLQuery.this.get(rs, expr, 1, expr.getType());
                }
            };
            return sQLResultIterator;
        }
        catch (SQLException e) {
            this.onException(context, e);
            throw this.configuration.translate(queryString, constants, e);
        }
        finally {
            this.endContext(context);
            this.reset();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public <RT> List<RT> list(Expression<RT> expr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <RT> SearchResults<RT> listResults(Expression<RT> expr) {
        QueryModifiers originalModifiers = this.queryMixin.getMetadata().getModifiers();
        try {
            if (this.configuration.getTemplates().isCountViaAnalytics()) {
                long total;
                List<RT> results;
                try {
                    this.queryMixin.addFlag(rowCountFlag);
                    this.getLastCell = true;
                    results = this.list(expr);
                }
                finally {
                    this.queryMixin.removeFlag(rowCountFlag);
                }
                if (!results.isEmpty()) {
                    if (!(this.lastCell instanceof Number)) throw new IllegalStateException("Unsupported lastCell instance " + this.lastCell);
                    total = ((Number)this.lastCell).longValue();
                } else {
                    total = this.count();
                }
                SearchResults<RT> searchResults = new SearchResults<RT>(results, originalModifiers, total);
                return searchResults;
            }
            this.queryMixin.addProjection(expr);
            long total = this.count();
            if (total > 0L) {
                this.queryMixin.getMetadata().clearProjection();
                SearchResults<RT> searchResults = new SearchResults<RT>(this.list(expr), originalModifiers, total);
                return searchResults;
            }
            SearchResults searchResults = SearchResults.emptyResults();
            return searchResults;
        }
        finally {
            this.getLastCell = false;
            this.reset();
        }
    }

    private <RT> RT newInstance(FactoryExpression<RT> c, ResultSet rs, int offset) throws InstantiationException, IllegalAccessException, InvocationTargetException, SQLException {
        Object[] args = new Object[c.getArgs().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.get(rs, c.getArgs().get(i), offset + i + 1, c.getArgs().get(i).getType());
        }
        return c.newInstance(args);
    }

    private void reset() {
        this.queryMixin.getMetadata().reset();
    }

    protected void setParameters(PreparedStatement stmt, List<?> objects, List<Path<?>> constantPaths, Map<ParamExpression<?>, ?> params) {
        if (objects.size() != constantPaths.size()) {
            throw new IllegalArgumentException("Expected " + objects.size() + " paths, but got " + constantPaths.size());
        }
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            try {
                if (o instanceof ParamExpression) {
                    if (!params.containsKey(o)) {
                        throw new ParamNotSetException((ParamExpression)o);
                    }
                    o = params.get(o);
                }
                this.set(stmt, constantPaths.get(i), i + 1, o);
                continue;
            }
            catch (SQLException e) {
                throw this.configuration.translate(e);
            }
        }
    }

    @Override
    public <RT> RT uniqueResult(Expression<RT> expr) {
        if (this.getMetadata().getModifiers().getLimit() == null && !expr.toString().contains("count(")) {
            this.limit(2L);
        }
        CloseableIterator<RT> iterator = this.iterate(expr);
        return ((ProjectableQuery)this).uniqueResult(iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long unsafeCount() throws SQLException {
        SQLListenerContextImpl context = this.startContext(this.conn, this.getMetadata());
        this.listeners.preRender(context);
        SQLSerializer serializer = this.serialize(true);
        String queryString = serializer.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("query : {}", (Object)queryString);
        }
        context.addSQL(queryString);
        this.listeners.rendered(context);
        List<Object> constants = serializer.getConstants();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            this.listeners.prePrepare(context);
            stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, constants, serializer.getConstantPaths(), this.getMetadata().getParams());
            context.addPreparedStatement(stmt);
            this.listeners.prepared(context);
            this.listeners.preExecute(context);
            rs = stmt.executeQuery();
            rs.next();
            this.listeners.executed(context);
            long l = rs.getLong(1);
            return l;
        }
        catch (SQLException e) {
            this.onException(context, e);
            throw this.configuration.translate(queryString, constants, e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            this.endContext(context);
        }
    }

    public void setUseLiterals(boolean useLiterals) {
        this.useLiterals = useLiterals;
    }

    @Override
    protected void clone(Q query) {
        super.clone(query);
        this.useLiterals = ((AbstractSQLQuery)query).useLiterals;
        this.listeners = new SQLListeners(((AbstractSQLQuery)query).listeners);
    }

    @Override
    public Q clone() {
        return this.clone(this.conn);
    }

    public abstract Q clone(Connection var1);
}

