/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.oracle;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.AbstractSQLQuery;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.OracleTemplates;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.sql.Connection;

public class OracleQuery
extends AbstractSQLQuery<OracleQuery> {
    private static final String CONNECT_BY = "\nconnect by ";
    private static final String CONNECT_BY_NOCYCLE_PRIOR = "\nconnect by nocycle prior ";
    private static final String CONNECT_BY_PRIOR = "\nconnect by prior ";
    private static final String ORDER_SIBLINGS_BY = "\norder siblings by ";
    private static final String START_WITH = "\nstart with ";

    public OracleQuery(Connection conn) {
        this(conn, new OracleTemplates(), (QueryMetadata)new DefaultQueryMetadata());
    }

    public OracleQuery(Connection conn, SQLTemplates templates) {
        this(conn, templates, (QueryMetadata)new DefaultQueryMetadata());
    }

    public OracleQuery(Connection conn, Configuration configuration) {
        super(conn, configuration, new DefaultQueryMetadata());
    }

    public OracleQuery(Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(conn, configuration, metadata);
    }

    protected OracleQuery(Connection conn, SQLTemplates templates, QueryMetadata metadata) {
        super(conn, new Configuration(templates), metadata);
    }

    public OracleQuery connectByPrior(Predicate cond) {
        return (OracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY_PRIOR, (Expression)cond);
    }

    public OracleQuery connectBy(Predicate cond) {
        return (OracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY, (Expression)cond);
    }

    public OracleQuery connectByNocyclePrior(Predicate cond) {
        return (OracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY_NOCYCLE_PRIOR, (Expression)cond);
    }

    public <A> OracleQuery startWith(Predicate cond) {
        return (OracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, START_WITH, (Expression)cond);
    }

    public OracleQuery orderSiblingsBy(Expression<?> path) {
        return (OracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, ORDER_SIBLINGS_BY, (Expression)path);
    }

    @Override
    public OracleQuery clone(Connection conn) {
        OracleQuery q = new OracleQuery(conn, this.getConfiguration(), this.getMetadata().clone());
        q.clone(this);
        return q;
    }
}

