/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.spatial;

import com.mysema.query.sql.types.AbstractType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.Wkt;

public class GeoDBWkbType
extends AbstractType<Geometry> {
    public static final GeoDBWkbType DEFAULT = new GeoDBWkbType();
    private final ByteOrder byteOrder = ByteOrder.NDR;

    public GeoDBWkbType() {
        super(2004);
    }

    @Override
    public Class<Geometry> getReturnedClass() {
        return Geometry.class;
    }

    @Override
    @Nullable
    public Geometry getValue(ResultSet rs, int startIndex) throws SQLException {
        byte[] bytes = rs.getBytes(startIndex);
        if (bytes != null) {
            byte[] wkb;
            if (bytes[0] != 0 && bytes[0] != 1) {
                wkb = new byte[bytes.length - 32];
                System.arraycopy(bytes, 32, wkb, 0, wkb.length);
            } else {
                wkb = bytes;
            }
            WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
            return decoder.decode(ByteBuffer.from((byte[])wkb));
        }
        return null;
    }

    @Override
    public void setValue(PreparedStatement st, int startIndex, Geometry value) throws SQLException {
        WkbEncoder encoder = Wkb.newEncoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
        ByteBuffer buffer = encoder.encode(value, this.byteOrder);
        st.setBytes(startIndex, buffer.toByteArray());
    }

    @Override
    public String getLiteral(Geometry geometry) {
        String str = Wkt.newEncoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).encode(geometry);
        if (geometry.getSRID() > -1) {
            return "ST_GeomFromText('" + str + "', " + geometry.getSRID() + ")";
        }
        return "ST_GeomFromText('" + str + "')";
    }
}

