/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.conditions;

import com.atlassian.plugin.PluginParseException;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.api.PluginPermission;
import java.util.HashSet;
import java.util.Set;

class ConfigurablePluginAccessPermissionsProvider {
    private static final String EDITOR_KEY = "editor";
    private static final String VIEWER_KEY = "viewer";
    private static final String ADMIN_KEY = "admin";
    private static final String LABS_KEY = "labs";
    private static final String TEAM_MANAGEMENT_KEY = "team-mgmt";

    ConfigurablePluginAccessPermissionsProvider() {
    }

    public static Set<PluginPermission> parse(String config) throws PluginParseException {
        HashSet keys = Sets.newHashSet((Object[])config.split(","));
        HashSet cleanedUpKeys = Sets.newHashSet((Iterable)Iterables.transform((Iterable)keys, (Function)new Function<String, String>(){

            public String apply(String s) {
                return s.trim().toLowerCase();
            }
        }));
        HashSet pluginPermission = Sets.newHashSet();
        for (String cleanedUpKey : cleanedUpKeys) {
            if (EDITOR_KEY.equals(cleanedUpKey)) {
                pluginPermission.add(PluginPermission.FullEditor);
                pluginPermission.add(PluginPermission.NonPublishingEditor);
                continue;
            }
            if (VIEWER_KEY.equals(cleanedUpKey)) {
                pluginPermission.add(PluginPermission.Viewer);
                continue;
            }
            if (ADMIN_KEY.equals(cleanedUpKey)) {
                pluginPermission.add(PluginPermission.Admin);
                continue;
            }
            if (LABS_KEY.equals(cleanedUpKey)) {
                pluginPermission.add(PluginPermission.LabsAccess);
                continue;
            }
            if (TEAM_MANAGEMENT_KEY.equals(cleanedUpKey)) {
                pluginPermission.add(PluginPermission.TeamManagementAccess);
                continue;
            }
            throw new PluginParseException(String.format("Unknown permission key '%s'.", cleanedUpKey));
        }
        return pluginPermission;
    }
}

