/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.backlog;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.generator.backlog.IEstimateConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IWorkItemConfiguration;
import java.util.Collections;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class AbstractWorkItemConfiguration
implements IWorkItemConfiguration {
    private final String title;
    private final Set<IEstimateConfiguration> estimationConfigurations;
    private final String releaseTitle;
    private final String teamTitle;
    private final String streamTitle;
    private final Long earliestStart;

    AbstractWorkItemConfiguration(String title, Set<IEstimateConfiguration> estimationConfigurations, String releaseTitle, String teamTitle, String streamTitle, Long earliestStart) {
        this.title = title;
        this.estimationConfigurations = Collections.unmodifiableSet(estimationConfigurations);
        this.releaseTitle = releaseTitle;
        this.teamTitle = teamTitle;
        this.streamTitle = streamTitle;
        this.earliestStart = earliestStart;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Set<IEstimateConfiguration> getEstimateConfigurations() {
        return this.estimationConfigurations;
    }

    @Override
    public Optional<String> getReleaseTitle() {
        return Optional.fromNullable((Object)this.releaseTitle);
    }

    @Override
    public Optional<String> getTeamTitle() {
        return Optional.fromNullable((Object)this.teamTitle);
    }

    @Override
    public Optional<String> getStreamTitle() {
        return Optional.fromNullable((Object)this.streamTitle);
    }

    @Override
    public Optional<Long> getEarliestStart() {
        return Optional.fromNullable((Object)this.earliestStart);
    }
}

