/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.backlog;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.generator.GeneratorUtils;
import com.radiantminds.roadmap.common.data.generator.backlog.IEstimateConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.sql.EstimateUpdateSQL;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimate;
import java.util.Set;

public class EstimatePersistency {
    private final EstimateUpdateSQL estimateUpdateSQL;

    public EstimatePersistency(ActiveObjectsUtilities activeObjectsUtilities) {
        this.estimateUpdateSQL = new EstimateUpdateSQL(activeObjectsUtilities);
    }

    public void persistEstimate(IEstimateConfiguration configuration, IWorkItem item, IPlan plan) throws Exception {
        RestEstimate estimate = new RestEstimate(configuration.getValue());
        String targetId = null;
        if ("stage".equals(configuration.getTargetType())) {
            targetId = ((IStage)GeneratorUtils.tryFindWithTitle((String)configuration.getTitle().get(), plan.getStages()).get()).getId();
        } else if ("skill".equals(configuration.getTargetType())) {
            Set<ISkill> skills = GeneratorUtils.getSkills(plan.getStages());
            targetId = ((ISkill)GeneratorUtils.tryFindWithTitle((String)configuration.getTitle().get(), skills).get()).getId();
        }
        this.estimateUpdateSQL.setEstimate(item.getId(), configuration.getTargetType(), targetId, DataMode.Default, estimate);
    }
}

