/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.settings;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.generator.GeneratorUtils;
import com.radiantminds.roadmap.common.data.generator.rand.settings.IRandomizedSettingsConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.settings.ISettingsConfigurationCreator;
import com.radiantminds.roadmap.common.data.generator.settings.ISettingsConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.ISkillConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.IStageConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.SettingsConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.SkillConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.StageConfiguration;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SettingsConfigurationCreator
implements ISettingsConfigurationCreator {
    private static final String STAGE_PREFIX = "stage-";
    private static final String SKILL_PREFIX = "skill-";
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    @Override
    public ISettingsConfiguration createConfiguration(IRandomizedSettingsConfiguration configuration, Random random) {
        ArrayList stageConfigurations = Lists.newArrayList();
        int stageCount = configuration.getStages();
        for (int stageIndex = 0; stageIndex < stageCount; ++stageIndex) {
            IStageConfiguration stageConfiguration = this.createStageConfiguration(stageIndex, configuration, random);
            stageConfigurations.add(stageConfiguration);
        }
        SettingsConfiguration settingsConfiguration = new SettingsConfiguration.Builder(stageConfigurations).build();
        return settingsConfiguration;
    }

    private IStageConfiguration createStageConfiguration(int stageIndex, IRandomizedSettingsConfiguration configuration, Random random) {
        String title = STAGE_PREFIX + stageIndex;
        List<ISkillConfiguration> skillConfigurations = this.createSkillConfigurations(stageIndex, configuration, random);
        Color randomColor = this.getRandomColor();
        StageConfiguration stageConfiguration = new StageConfiguration.Builder(title).withSkillConfigurations(skillConfigurations).withColor(randomColor).build();
        return stageConfiguration;
    }

    private Color getRandomColor() {
        Color color = new Color(RANDOM.nextInt(256), RANDOM.nextInt(256), RANDOM.nextInt(256));
        return color;
    }

    private List<ISkillConfiguration> createSkillConfigurations(int stageIndex, IRandomizedSettingsConfiguration configuration, Random random) {
        ArrayList skillConfigurations = Lists.newArrayList();
        int numberOfSkills = GeneratorUtils.getRandomFromInterval(configuration.getMinSkills(), configuration.getMaxSkills(), random);
        for (int skillIndex = 0; skillIndex < numberOfSkills; ++skillIndex) {
            String title = SKILL_PREFIX + stageIndex + "-" + skillIndex;
            SkillConfiguration skillConfiguration = new SkillConfiguration.Builder(title).build();
            skillConfigurations.add(skillConfiguration);
        }
        return skillConfigurations;
    }
}

