/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.teams;

import com.google.common.base.Preconditions;

public class RandomizedResourceConfiguration {
    private final int minNumberSkills;
    private final int maxNumberSkills;

    public RandomizedResourceConfiguration(int minNumberSkills, int maxNumberSkills) {
        this.minNumberSkills = minNumberSkills;
        this.maxNumberSkills = maxNumberSkills;
    }

    public int getMinNumberSkills() {
        return this.minNumberSkills;
    }

    public int getMaxNumberSkills() {
        return this.maxNumberSkills;
    }

    public static class Builder {
        private int minNumberSkills = 1;
        private int maxNumberSkills = 20;

        public Builder withNumberOfSkillsBetween(int minNumberSkills, int maxNumberSkills) {
            Preconditions.checkArgument((minNumberSkills <= maxNumberSkills ? 1 : 0) != 0);
            this.minNumberSkills = minNumberSkills;
            this.maxNumberSkills = maxNumberSkills;
            return this;
        }

        public RandomizedResourceConfiguration build() {
            return new RandomizedResourceConfiguration(this.minNumberSkills, this.maxNumberSkills);
        }
    }
}

