/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.time;

import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.generator.rand.time.IRandomizedTimePlanConfiguration;
import org.joda.time.DateTime;

public class RandomizedTimePlanConfiguration
implements IRandomizedTimePlanConfiguration {
    private final int releaseCount;
    private final DateTime startDate;
    private final int minReleaseDurationInDays;
    private final int maxReleaseDurationInDays;

    protected RandomizedTimePlanConfiguration(int releaseCount, DateTime startDate, int minReleaseDurationInDays, int maxReleaseDurationInDays) {
        this.releaseCount = releaseCount;
        this.startDate = startDate;
        this.minReleaseDurationInDays = minReleaseDurationInDays;
        this.maxReleaseDurationInDays = maxReleaseDurationInDays;
    }

    @Override
    public int getReleasesCount() {
        return this.releaseCount;
    }

    @Override
    public DateTime getStartDate() {
        return this.startDate;
    }

    @Override
    public int getMinReleaseDurationInDays() {
        return this.minReleaseDurationInDays;
    }

    @Override
    public int getMaxReleaseDurationInDays() {
        return this.maxReleaseDurationInDays;
    }

    public static class Builder {
        private int releaseCount = 4;
        private DateTime startDate = new DateTime();
        private int minReleaseDurationInDays = 40;
        private int maxReleaseDurationInDays = 80;

        public Builder withReleaseCount(int releaseCount) {
            this.releaseCount = releaseCount;
            return this;
        }

        public Builder withStartDate(DateTime startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder withReleaseDurationInDaysBetween(int minReleaseDuration, int maxReleaseDuration) {
            Preconditions.checkArgument((minReleaseDuration <= maxReleaseDuration ? 1 : 0) != 0);
            this.minReleaseDurationInDays = minReleaseDuration;
            this.maxReleaseDurationInDays = maxReleaseDuration;
            return this;
        }

        public RandomizedTimePlanConfiguration build() {
            return new RandomizedTimePlanConfiguration(this.releaseCount, this.startDate, this.minReleaseDurationInDays, this.maxReleaseDurationInDays);
        }
    }
}

