/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.integrity.rank;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.ISortable;
import com.radiantminds.roadmap.common.data.integrity.rank.BaseSortableIntegrityChecker;
import com.radiantminds.roadmap.common.data.integrity.rank.configurations.RepairConfigurations;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderRangeIdentifierIntegrityChecker
extends BaseSortableIntegrityChecker {
    private static final Log LOGGER = Log.with(OrderRangeIdentifierIntegrityChecker.class);

    @Autowired
    public OrderRangeIdentifierIntegrityChecker(ActiveObjectsUtilities activeObjectsUtilities) {
        super(LOGGER, activeObjectsUtilities);
    }

    @Override
    protected List<Class<? extends ISortable>> getApplicableTables() {
        for (Class<? extends ISortable> clazz : super.getApplicableTables()) {
            if (RepairConfigurations.has(clazz)) continue;
            throw new IllegalArgumentException("No FK repair defined for class '" + clazz + "'");
        }
        return super.getApplicableTables();
    }

    @Override
    protected void checkClassForRankIntegrity(Connection connection, String planId, Class<? extends ISortable> clazz) throws SQLException {
        Set<String> idsWithoutIdentifier = this.getIdsWithoutIdentifiers(clazz, planId, connection);
        if (idsWithoutIdentifier.size() > 0) {
            for (String id : idsWithoutIdentifier) {
                LOGGER.warn("Found rank integrity issue: ID %s table %s has no order range identifier.", id, clazz);
                this.repairRangeIdentifier(clazz, connection, id);
            }
        }
    }

    private void repairRangeIdentifier(final Class<? extends ISortable> clazz, Connection connection, final String id) throws SQLException {
        final String repairFk = this.sql(new IQuery<String>(){

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(clazz, "t").select().col("t", RepairConfigurations.get(clazz).getForeignKeyColumnIdentifier()).from("t").where().colId("t").eq().numeric(id);
            }
        }, connection, false);
        if (repairFk == null) {
            LOGGER.error("Cannot repair order range identifier of item %s in table %s. Foreign key %s is null!", id, clazz, RepairConfigurations.get(clazz).getForeignKeyColumnIdentifier());
            return;
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(clazz, "t").update().tableNoAlias("t").set().colNoAlias("t", "orderRangeIdentifier").eq().str(RepairConfigurations.get(clazz).getOrderRangeIdentifierPrefix() + repairFk).where().colIdNoAlias("t").eq().numeric(id);
            }
        }, connection, false);
    }

    private Set<String> getIdsWithoutIdentifiers(final Class<?> table, final String planId, Connection connection) throws SQLException {
        return this.sql(new IQuery<Set<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(table, "t").select().colId("t").from("t");
                RepairConfigurations.get(table).applyPlanJoin("t", generator);
                generator.where().col("t", "orderRangeIdentifier").isNull();
                generator.and();
                RepairConfigurations.get(table).applyPlanCondition("t", planId, generator);
            }

            @Override
            public Set<String> handleResult(ResultSet result) throws Exception {
                HashSet ids = Sets.newHashSet();
                while (result.next()) {
                    ids.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return ids;
            }
        }, connection, false);
    }
}

