/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.MoveMode;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.TransactionalSortingSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.IResultAwareQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.ResultAwareQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SortingSQL
extends BaseAOPersistenceSQL {
    private final TransactionalSortingSQL transactionalSortingSQL;

    public SortingSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.transactionalSortingSQL = new TransactionalSortingSQL(activeObjectsUtilities);
    }

    public void shiftAll(final String rangeId, final Class<?> table) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(table, "t").update().tableNoAlias("t").set().colNoAlias("t", "sortOrder").eq().raw("(").colNoAlias("t", "sortOrder").raw(" + 1)").where().colNoAlias("t", "orderrange").eq().str(rangeId);
            }
        });
    }

    public void shiftAll(final String rangeId, final Long gteSortOrder, final Class<?> table) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(table, "t").update().tableNoAlias("t").set().colNoAlias("t", "sortOrder").eq().raw("(").colNoAlias("t", "sortOrder").raw(" + 1)").where().colNoAlias("t", "orderrange").eq().str(rangeId).and().colNoAlias("t", "sortOrder").gte().numeric(gteSortOrder);
            }
        });
    }

    public void move(String orderRangeIdentifier, Class<?> table, String id, MoveMode mode, String anchor) throws SQLException {
        if (anchor == null) {
            mode = MoveMode.TOP;
        }
        this.transactionalSortingSQL.moveToPosition(table, orderRangeIdentifier, id, mode, anchor);
    }

    public void setSortOrder(final Class<?> table, final String id, final Long sortOrder, final String orderRangeIdentifier) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(table, "t").update().tableNoAlias("t").set().colNoAlias("t", "sortOrder").eq().numeric(sortOrder).raw(", ").colNoAlias("t", "orderRangeId").eq().str(orderRangeIdentifier).where().colIdNoAlias("t").eq().numeric(id);
            }
        });
    }

    public IResultAwareQuery<Long> getSortOrderQuery(final Class<?> table, final String id) throws SQLException {
        return new ResultAwareQuery<Long>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(table, "t").select().col("t", "sortOrder").from("t").where().colIdNoAlias("t").eq().numeric(id);
            }

            @Override
            public Long handleAndStoreResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return SortingSQL.getLong(result, 1);
                }
                return null;
            }
        };
    }

    public Long getSortOrder(Class<?> table, String id) throws SQLException {
        return this.sql(this.getSortOrderQuery(table, id).query());
    }

    public Long getSortOrderInCustomTransaction(Class<?> table, String id, Connection connection) throws SQLException {
        return this.sql(this.getSortOrderQuery(table, id).query(), connection, false);
    }

    public String getRangeIdentifier(final Class<?> table, final String id) throws SQLException {
        return this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(table, "t").select().col("t", "orderRangeIdentifier").from("t").where().colId("t").eq().numeric(id);
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }
        });
    }

    public void clearSortOrder(String id, Class<?> clazz) throws SQLException {
        this.clearSortOrderInternal(id, clazz, true);
    }

    public void clearSortOrderDontCascade(String id, Class<?> clazz) throws SQLException {
        this.clearSortOrderInternal(id, clazz, false);
    }

    private void clearSortOrderInternal(final String id, final Class<?> clazz, boolean cascade) throws SQLException {
        final Long sortOrder = this.getSortOrder(clazz, id);
        final String orderRangeIdentifier = this.getRangeIdentifier(clazz, id);
        if (cascade && sortOrder != null) {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(clazz, "t").withTable(clazz, "innerT").update().tableNoAlias("t").set().colNoAlias("t", "sortOrder").eq().raw("(").colNoAlias("t", "sortOrder").raw(" - 1)").where().colNoAlias("t", "orderRangeIdentifier").eq().str(orderRangeIdentifier).and().colNoAlias("t", "sortOrder").gt().numeric(sortOrder);
                }
            });
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(clazz, "t").update().tableNoAlias("t").set().colNoAlias("t", "orderRangeIdentifier").eq().raw("NULL, ").colNoAlias("t", "sortOrder").eq().raw("NULL").where().colIdNoAlias("t").eq().numeric(id);
            }
        });
    }
}

