/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.AOEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.PersonSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.usermanagement.UserManagementExtension;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsPersonPersistence
extends AOEntityPersistence<IPerson, AOPerson>
implements PortfolioPersonPersistence {
    private final PersonSQL personSQL;
    private final EntityInfoSQL entityInfoSQL;
    private final PortfolioPlanPersistence planPersistence;
    private final UserManagementExtension userManagementExtension;

    @Autowired
    public PortfolioActiveObjectsPersonPersistence(ActiveObjectsUtilities utils, PortfolioPlanPersistence planPersistence, UserManagementExtension userManagementExtension) {
        super(utils, IPerson.class, AOPerson.class);
        this.planPersistence = planPersistence;
        this.userManagementExtension = userManagementExtension;
        this.personSQL = new PersonSQL(utils, userManagementExtension);
        this.entityInfoSQL = new EntityInfoSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioPersonPersistence.class;
    }

    @Override
    protected void transform(IPerson source, AOPerson target) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        target.setExternalId(source.getExternalId().isPresent() ? (String)source.getExternalId().get() : null);
        if (source.getPlan() != null) {
            target.setPlan((IPlan)this.planPersistence.get(source.getPlan().getId()));
        }
    }

    @Override
    public EntityInfo getEntityInfo(String personId) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(personId, AOPerson.class, new EntityInfoSQL.ParentRelationship[0]);
    }

    private void enrich(IPerson person) {
        if (person != null && person.getExternalId().isPresent() && this.userManagementExtension.isUserManagementFor((String)person.getExternalId().get())) {
            if (this.userManagementExtension.exists((String)person.getExternalId().get())) {
                this.userManagementExtension.enrich(person);
                person.setExternal(true);
            } else {
                person.setExternal(false);
            }
        }
    }

    @Override
    public IPerson get(String id) throws PersistenceException {
        IPerson retVal = (IPerson)super.get(id);
        this.enrich(retVal);
        return retVal;
    }

    @Override
    public IPerson persist(IPerson entity) throws PersistenceException {
        return this.persist(entity, true);
    }

    @Override
    public IPerson persist(IPerson entity, boolean increment) throws PersistenceException {
        if (entity.getExternalId() != null) {
            entity.setExternal(true);
        }
        IPerson retVal = super.persist(entity, increment);
        this.enrich(retVal);
        return retVal;
    }

    @Override
    public List<IPerson> list() throws PersistenceException {
        List<IPerson> retVal = super.list();
        for (IPerson person : retVal) {
            this.enrich(person);
        }
        return retVal;
    }

    @Override
    public List<IPerson> listAllPersonsForPlan(String planId, boolean enrich) throws SQLException {
        return Lists.newArrayList(this.personSQL.getPersons(planId, enrich).values());
    }

    @Override
    public List<IPerson> listAllPersonsWithoutAbilities(String planId, boolean enrich) throws SQLException {
        return this.personSQL.getAllPersonsWithoutAbilities(planId, enrich);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOPerson.class, "p").withTable(AOTeam.class, "t").withTable(AOResource.class, "s").select().raw("*").from("p").where().col("p", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().raw("(").select().raw("MIN(").col("t", "sortOrder").raw(")").from("s", "t").where().colId("t").eq().col("s", "aoTeam").and().colId("p").eq().col("s", "aoPerson").raw("),(").select().raw("MIN(").col("s", "sortOrder").raw(")").from("s").where().colId("p").eq().col("s", "aoPerson").raw(")");
        }
    }
}

