/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IAbsence;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals.AOAbsence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.PersonIntervalSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbsenceIntervalPersistence;
import com.radiantminds.roadmap.common.rest.entities.people.RestAbsence;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsAbsenceIntervalPersistence
extends AOSortableEntityPersistence<IAbsence, AOAbsence>
implements PortfolioAbsenceIntervalPersistence {
    private final PersonIntervalSQL personIntervalSQL;
    private final EntityInfoSQL entityInfoSQL;

    @Autowired
    public PortfolioActiveObjectsAbsenceIntervalPersistence(ActiveObjectsUtilities utils) {
        super(utils, IAbsence.class, AOAbsence.class);
        this.personIntervalSQL = new PersonIntervalSQL(utils);
        this.entityInfoSQL = new EntityInfoSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioAbsenceIntervalPersistence.class;
    }

    @Override
    protected void transform(IAbsence source, AOAbsence target) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        TransformerUtils.transformSortable(source, target);
        target.setStartDate(source.getStartDate());
        target.setEndDate(source.getEndDate());
        if (source.getPerson() != null) {
            target.setPerson(source.getPerson());
        }
    }

    @Override
    public EntityInfo getEntityInfo(String intervalId) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(intervalId, AOAbsence.class, new EntityInfoSQL.ParentRelationship(AOPerson.class, "aoPerson"));
    }

    @Override
    public List<IAbsence> listForPerson(String personId) throws SQLException {
        return Lists.newArrayList(this.personIntervalSQL.listForPerson(AOAbsence.class, RestAbsence.class, personId));
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOAbsence.class, "t").withTable(AOPerson.class, "h1").select().raw("t.*").from("t").leftJoin().table("h1").on().col("t", "aoPerson").eq().colId("h1").where().col("h1", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().col("t", "sortOrder").colId("t");
        }
    }
}

