/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.rest.entities.people.RestResource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ResourceSQL
extends BaseAOPersistenceSQL {
    public ResourceSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public List<IResource> listForTeam(final String teamId) throws SQLException {
        return this.sql(new IQuery<List<IResource>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOResource.class, "r").select().col("r", "ID_OTHER", false).col("r", "version").col("r", "aoperson").col("r", "availability").col("r", "sortOrder").from("r").where().col("r", "aoteam").eq().numeric(teamId).orderBy().col("r", "sortOrder");
            }

            @Override
            public List<IResource> handleResult(ResultSet result) throws Exception {
                ArrayList resources = Lists.newArrayList();
                while (result.next()) {
                    String resourceId = BaseAOPersistenceSQL.getString(result, 1);
                    Long version = ResourceSQL.getLong(result, 2);
                    String personId = BaseAOPersistenceSQL.getString(result, 3);
                    Double availability = BaseAOPersistenceSQL.getDouble(result, 4);
                    Long sortOrder = ResourceSQL.getLong(result, 5);
                    RestResource resource = new RestResource(resourceId, personId);
                    resource.setVersion(version);
                    resource.setAvailability(availability);
                    resource.setSortOrder(sortOrder);
                    resources.add(resource);
                }
                return resources;
            }
        });
    }

    public List<String> getResourceIdsForPersonIds(final String planId, final List<String> ids) throws SQLException {
        return this.sql(new IQuery<List<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOResource.class, "r").withTable(AOTeam.class, "t").withTable(AOPerson.class, "p").select().colId("r").from("r", "t", "p").where().col("r", "aoteam").eq().colId("t").and().col("r", "aoperson").eq().colId("p").and().col("t", "aoplan").eq().numeric(planId).and().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colId("p");
                    }
                }, ids);
            }

            @Override
            public List<String> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    retVal.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return retVal;
            }
        });
    }
}

