/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOSprint;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.rest.entities.people.RestSprint;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SprintSQL
extends BaseAOPersistenceSQL {
    public SprintSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public List<ISprint> listForTeam(final String teamId) throws SQLException {
        return this.sql(new IQuery<List<ISprint>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOSprint.class, "s").select().col("s", "ID_OTHER", false).col("s", "version").col("s", "title").col("s", "startDate").col("s", "endDate").col("s", "sortOrder").from("s").where().col("s", "aoteam").eq().numeric(teamId).orderBy().col("s", "sortOrder");
            }

            @Override
            public List<ISprint> handleResult(ResultSet result) throws Exception {
                ArrayList sprints = Lists.newArrayList();
                while (result.next()) {
                    String sprintId = BaseAOPersistenceSQL.getString(result, 1);
                    Long version = SprintSQL.getLong(result, 2);
                    String title = BaseAOPersistenceSQL.getString(result, 3);
                    Long startDate = SprintSQL.getLong(result, 4);
                    Long endDate = SprintSQL.getLong(result, 5);
                    Long sortOrder = SprintSQL.getLong(result, 6);
                    RestSprint sprint = new RestSprint(sprintId, title, startDate, endDate);
                    sprint.setVersion(version);
                    sprint.setSortOrder(sortOrder);
                    sprints.add(sprint);
                }
                return sprints;
            }
        });
    }
}

