/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.people.IterationStartType;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOSprint;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.AvailabilityIntervalSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.rest.entities.people.RestResource;
import com.radiantminds.roadmap.common.rest.entities.people.RestSprint;
import com.radiantminds.roadmap.common.rest.entities.people.RestTeam;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TeamSQL
extends BaseAOPersistenceSQL {
    private final AvailabilityIntervalSQL availabilityIntervalSQL;
    private final ActiveObjectsUtilities activeObjectsUtilities;

    public TeamSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.activeObjectsUtilities = activeObjectsUtilities;
        this.availabilityIntervalSQL = new AvailabilityIntervalSQL(activeObjectsUtilities);
    }

    public List<ITeam> getTeams(String planId) throws SQLException {
        return this.getTeams(planId, null);
    }

    public List<ITeam> getTeams(final String planId, final Map<String, IPerson> persons) throws SQLException {
        return this.sql(new IQuery<List<ITeam>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                String team = "t";
                String resource = "r";
                String sprint = "s";
                generator.withTable(AOTeam.class, team).withTable(AOResource.class, resource).withTable(AOSprint.class, sprint).select().col(team, "ID_OTHER", false).col(team, "version").col(team, "title").col(team, "details").col(team, "sortOrder").col(team, "weeksPerSprint").col(team, "velocity").col(team, "incrementalAdjustment").col(team, "autoAdjustToAbsences").col(team, "planningMode").col(team, "iterationStartType").col(resource, "ID_OTHER", false).col(resource, "version").col(resource, "aoperson").col(resource, "availability").col(resource, "sortOrder").col(sprint, "ID_OTHER", false).col(sprint, "version").col(sprint, "title").col(sprint, "startDate").col(sprint, "endDate").col(sprint, "sortOrder").from(team).leftJoin().table(resource).on().col(resource, "aoteam").eq().col(team, "ID_OTHER", false).leftJoin().table(sprint).on().col(sprint, "aoteam").eq().col(team, "ID_OTHER", false).where().col(team, "aoplan").eq().numeric(planId).orderBy().col(team, "sortOrder").col(resource, "sortOrder").col(sprint, "sortOrder");
            }

            @Override
            public List<ITeam> handleResult(ResultSet result) throws Exception {
                LinkedHashMap teams = Maps.newLinkedHashMap();
                HashSet resourceIds = Sets.newHashSet();
                HashSet sprintIds = Sets.newHashSet();
                while (result.next()) {
                    Long sortOrder;
                    String title;
                    Long version;
                    String teamId = BaseAOPersistenceSQL.getString(result, 1);
                    String resourceId = BaseAOPersistenceSQL.getString(result, 12);
                    String sprintId = BaseAOPersistenceSQL.getString(result, 17);
                    if (!teams.containsKey(teamId)) {
                        version = TeamSQL.getLong(result, 2);
                        title = BaseAOPersistenceSQL.getString(result, 3);
                        String description = BaseAOPersistenceSQL.getString(result, 4);
                        sortOrder = TeamSQL.getLong(result, 5);
                        Integer weeksPerSprint = TeamSQL.getInteger(result, 6);
                        Double velocity = BaseAOPersistenceSQL.getDouble(result, 7);
                        Double incrementalAdjustment = BaseAOPersistenceSQL.getDouble(result, 8);
                        Boolean autoAdjustToAbsences = BaseAOPersistenceSQL.getBoolean(result, 9);
                        String planningMode = BaseAOPersistenceSQL.getString(result, 10);
                        String iterationStartType = BaseAOPersistenceSQL.getString(result, 11);
                        if (planningMode == null) {
                            planningMode = PlanningMode.Scrum.toString();
                        }
                        if (iterationStartType == null) {
                            iterationStartType = IterationStartType.WithReleaseStartDate.toString();
                        }
                        RestTeam team = new RestTeam(teamId, title, description);
                        team.setVersion(version);
                        team.setSortOrder(sortOrder);
                        team.setPlanningMode(PlanningMode.valueOf(planningMode));
                        team.setIterationStartType(IterationStartType.valueOf(iterationStartType));
                        team.setWeeksPerSprint(weeksPerSprint);
                        team.setVelocity(velocity);
                        team.setIncrementalAdjustment(incrementalAdjustment);
                        team.setAutoAdjustToAbsences(autoAdjustToAbsences);
                        teams.put(teamId, team);
                    }
                    if (resourceId != null && !resourceIds.contains(resourceId)) {
                        version = TeamSQL.getLong(result, 13);
                        String personId = BaseAOPersistenceSQL.getString(result, 14);
                        Double availability = BaseAOPersistenceSQL.getDouble(result, 15);
                        sortOrder = TeamSQL.getLong(result, 16);
                        RestResource resource = new RestResource(resourceId, personId);
                        resource.setVersion(version);
                        resource.setAvailability(availability);
                        resource.setSortOrder(sortOrder);
                        if (persons != null) {
                            resource.setPerson((IPerson)persons.get(personId));
                        }
                        resource.setAvailabilityIntervals(TeamSQL.this.availabilityIntervalSQL.listForResource(resourceId));
                        resourceIds.add(resourceId);
                        ((RestTeam)teams.get(teamId)).addRestResource(resource);
                    }
                    if (sprintId == null || sprintIds.contains(sprintId)) continue;
                    version = TeamSQL.getLong(result, 18);
                    title = BaseAOPersistenceSQL.getString(result, 19);
                    Long startDate = TeamSQL.getLong(result, 20);
                    Long endDate = TeamSQL.getLong(result, 21);
                    Long sortOrder2 = TeamSQL.getLong(result, 22);
                    RestSprint sprint = new RestSprint(sprintId, title, startDate, endDate);
                    sprint.setVersion(version);
                    sprint.setSortOrder(sortOrder2);
                    sprintIds.add(sprintId);
                    ((RestTeam)teams.get(teamId)).addRestSprint(sprint);
                }
                return Lists.newArrayList(teams.values());
            }
        });
    }

    public void updateVelocitySettings(final String teamId, final Double velocity, final Double incrementalAdjustment, final Boolean autoAdjustToAbsences) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOTeam.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "velocity").eq().numeric(velocity).raw(",").colNoAlias("w", "incrementalAdjustment").eq().numeric(incrementalAdjustment).raw(",").colNoAlias("w", "autoAdjustToAbsences").eq().bool(autoAdjustToAbsences).where().colIdNoAlias("w").eq().numeric(teamId);
            }
        });
    }

    public void setPlanningMode(final String teamId, final PlanningMode planningMode) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOTeam.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "planningMode").eq().str((Object)planningMode).where().colIdNoAlias("w").eq().numeric(teamId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean allTeamsInPlanUseScrum(String planId) throws SQLException {
        Connection connection = this.activeObjectsUtilities.getOrCreateConnection();
        try {
            Boolean bl = this.allTeamsInPlanUseScrum(planId, connection);
            return bl;
        }
        finally {
            connection.commit();
            connection.close();
        }
    }

    public Boolean allTeamsInPlanUseScrum(final String planId, Connection connection) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                String team = "t";
                generator.withTable(AOTeam.class, team).select().raw("COUNT(*)").from(team).where().col(team, "planningMode").eq().str(PlanningMode.Kanban.name()).and().col(team, "aoplan").eq().numeric(planId);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getInt(result, 1) == 0;
                }
                return true;
            }
        }, connection, false);
    }
}

