/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.permissions.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.permissions.AOPermission;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.rest.entities.permissions.RestPermission;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PermissionSQL
extends BaseAOPersistenceSQL {
    public PermissionSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public Boolean testPluginPermissions(final Collection<String> targetIds, final String userId, final Collection<String> userGroupIds) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPermission.class, "p").select().raw("count(*)").from("p").where().col("p", "targetType").eq().str("system").and().raw("(").raw("(").col("p", "holderId").eq().str(userId).and().col("p", "holderType").eq().str("user").raw(")");
                if (userGroupIds.size() > 0) {
                    generator.or().raw("(").in(new AOQueryGenerator.InOperandCallback(){

                        @Override
                        public void generateOperand(AOQueryGenerator generator) {
                            generator.col("p", "holderId");
                        }
                    }, userGroupIds).and().col("p", "holderType").eq().str("group").raw(")");
                }
                generator.raw(")").and().in(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.col("p", "targetId");
                    }
                }, targetIds);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return PermissionSQL.getLong(result, 1) > 0L;
                }
                return false;
            }
        });
    }

    public List<IPermission> getPermissions(final String targetType, final String targetId) throws SQLException {
        return this.sql(new IQuery<List<IPermission>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPermission.class, "p").select().colId("p").col("p", "holderId").col("p", "holderType").col("p", "permission").from("p").where().col("p", "targetType").eq().str(targetType);
                if (targetId != null) {
                    generator.and().col("p", "targetId").eq().str(targetId);
                }
            }

            @Override
            public List<IPermission> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    String id = BaseAOPersistenceSQL.getString(result, 1);
                    String holderId = BaseAOPersistenceSQL.getString(result, 2);
                    String holderType = BaseAOPersistenceSQL.getString(result, 3);
                    Integer permission = BaseAOPersistenceSQL.getInt(result, 4);
                    RestPermission entity = new RestPermission();
                    entity.setId(id);
                    entity.setHolderId(holderId);
                    entity.setHolderType(holderType);
                    entity.setPermission(permission);
                    entity.setTargetId(targetId);
                    entity.setTargetType(targetType);
                    retVal.add(entity);
                }
                return retVal;
            }
        });
    }

    public void removePermissionsForPlan(final String planId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPermission.class, "p").deleteFrom().tableNoAlias("p").where().colNoAlias("p", "targetType").eq().str("plan").and().colNoAlias("p", "targetId").eq().str(planId);
            }
        });
    }

    public boolean exists(final IPermission permission) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPermission.class, "p").select().raw("*").from("p").where().col("p", "permission").eq().numeric(permission.getPermission()).and().col("p", "targetType").eq().str(permission.getTargetType()).and().col("p", "targetId").eq().str(permission.getTargetId()).and().col("p", "holderType").eq().str(permission.getHolderType()).and().col("p", "holderId").eq().str(permission.getHolderId());
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                return result.next();
            }
        });
    }
}

