/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.releases;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOTransformer;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.sql.StreamToTeamSql;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.sql.StreamSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemRelationSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsStreamPersistence
extends AOSortableEntityPersistence<IStream, AOStream>
implements PortfolioStreamPersistence {
    private static final Log LOGGER = Log.with(PortfolioActiveObjectsStreamPersistence.class);
    private final WorkItemRelationSQL workItemRelationSQL;
    private final StreamSQL streamSQL;
    private final StreamToTeamSql streamToTeamSql;
    private final EntityInfoSQL entityInfoSQL;
    private final PersistenceIndex persistenceIndex;
    private final PortfolioPlanPersistence planPersistence;

    @Autowired
    public PortfolioActiveObjectsStreamPersistence(PersistenceIndex persistenceIndex, ActiveObjectsUtilities utils, PortfolioPlanPersistence planPersistence) {
        super(utils, IStream.class, AOStream.class);
        this.persistenceIndex = persistenceIndex;
        this.planPersistence = planPersistence;
        this.workItemRelationSQL = new WorkItemRelationSQL(utils);
        this.streamSQL = new StreamSQL(persistenceIndex, utils);
        this.entityInfoSQL = new EntityInfoSQL(utils);
        this.streamToTeamSql = new StreamToTeamSql(persistenceIndex, utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioStreamPersistence.class;
    }

    @Override
    protected void transform(IStream source, AOStream target) throws Exception {
        PortfolioActiveObjectsStreamPersistence.transformStream(source, target, this.planPersistence);
    }

    public static void transformStream(IStream source, AOStream target, PortfolioPlanPersistence planPersistence) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        TransformerUtils.transformSortable(source, target);
        if (source.getPlan() != null) {
            target.setPlan((IPlan)planPersistence.get(source.getPlan().getId()));
        }
        target.setColor(source.getColor());
        target.setShortName(source.getShortName());
    }

    @Override
    public EntityInfo getEntityInfo(String streamId) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(streamId, AOStream.class, new EntityInfoSQL.ParentRelationship[0]);
    }

    @Override
    public void onAfterCreate(IStream entity) throws PersistenceException {
        LOGGER.info("New release stream created with identifier '%s', initializing later release...", entity.getId());
        IRelease laterRelease = this.persistRelease((IRelease)this.getUtils().create(AORelease.class));
        laterRelease.setTitle("Later");
        laterRelease.setFixedEndDate(Long.MAX_VALUE);
        laterRelease.setStream(entity);
        laterRelease.setIsLaterRelease(true);
        laterRelease.setVersion(0L);
        IRelease release = this.persistRelease(laterRelease);
        LOGGER.info("Created later release with id '%s' for stream '%s'", release.getId(), entity.getId());
        super.onAfterCreate(entity);
    }

    private IRelease persistRelease(IRelease release) throws PersistenceException {
        final PortfolioReleasePersistence releasePersistence = this.persistenceIndex.getBeanFromContext(PortfolioReleasePersistence.class);
        return this.getUtils().persist(IRelease.class, AORelease.class, release, new AOTransformer<IRelease, AORelease>(){

            @Override
            public void copyValues(IRelease source, AORelease target) throws Exception {
                releasePersistence.transformRelease(source, target);
            }
        }, false);
    }

    @Override
    public boolean delete(String id, boolean inCascade) throws PersistenceException {
        try {
            this.workItemRelationSQL.deleteReplanningRelationsForTarget(id, "stream");
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to cascade delete replannings for stream '" + id + "'", ex);
        }
        try {
            this.streamToTeamSql.clearTeamAssignmentsForStream(id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to delete team assignments for stream '" + id + "'", ex);
        }
        return super.delete(id, inCascade);
    }

    @Override
    public List<IStream> listCustom(String planId) throws SQLException {
        return Lists.newArrayList(this.streamSQL.listCustom(planId));
    }

    @Override
    public List<IStream> listCustomWithReleases(String planId) throws SQLException {
        return Lists.newArrayList(this.streamSQL.listCustomWithReleases(planId));
    }

    @Override
    public Set<String> getRestrictedTeamIds(String streamId) throws SQLException {
        return this.streamToTeamSql.getRestrictedTeamIds(streamId);
    }

    @Override
    public void setRestrictedTeamIds(String streamId, Set<String> teamIds) throws SQLException {
        this.streamToTeamSql.clearTeamAssignmentsForStream(streamId);
        if (teamIds != null && !teamIds.isEmpty()) {
            this.streamToTeamSql.setTeamAssignment(streamId, teamIds);
        }
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOStream.class, "t").select().raw("*").from("t").where().col("t", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().col("t", "sortOrder").colId("t");
        }
    }
}

