/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.sql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions.AOExtensionLink;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.sql.StreamToTeamSql;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.sql.ReleaseSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.rest.entities.releases.RestRelease;
import com.radiantminds.roadmap.common.rest.entities.releases.RestStream;
import com.radiantminds.roadmap.common.rest.entities.releases.links.RestReleaseExtensionLinkResponse;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class StreamSQL
extends BaseAOPersistenceSQL {
    private final ReleaseSQL releaseSQL;
    private final StreamToTeamSql streamToTeamSql;

    public StreamSQL(PersistenceIndex persistenceIndex, ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.releaseSQL = new ReleaseSQL(activeObjectsUtilities);
        this.streamToTeamSql = new StreamToTeamSql(persistenceIndex, activeObjectsUtilities);
    }

    public List<RestStream> listCustomWithReleases(final String planId) throws SQLException {
        return this.sql(new IQuery<List<RestStream>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOStream.class, "s").withTable(AORelease.class, "r").withTable(AOExtensionLink.class, "l").select();
                StreamSQL.addStreamSelect(generator, "s");
                ReleaseSQL.addReleaseSelect(generator, "r");
                StreamSQL.addExtensionLinkSelect(generator, "l");
                generator.from("s").leftJoin().table("r").on().col("r", "aoStream").eq().colId("s").leftJoin().table("l").on().colId("r").eq().col("l", "aoExtendable").and().colPolyType("l", "aoExtendable").eq().str(AORelease.class.getName()).where().col("s", "aoPlan").eq().numeric(planId).orderBy().col("s", "sortOrder").col("r", "sortOrder");
            }

            @Override
            public List<RestStream> handleResult(ResultSet result) throws Exception {
                LinkedHashMap streams = Maps.newLinkedHashMap();
                HashMap releases = Maps.newHashMap();
                while (result.next()) {
                    RestRelease release;
                    RestStream stream;
                    String streamId = BaseAOPersistenceSQL.getString(result, 1);
                    if (!streams.containsKey(streamId)) {
                        stream = StreamSQL.this.parseStream(result);
                        stream.setReleases(Lists.newArrayList());
                        streams.put(streamId, stream);
                    } else {
                        stream = (RestStream)streams.get(streamId);
                    }
                    String releaseId = BaseAOPersistenceSQL.getString(result, 8);
                    if (!releases.containsKey(releaseId)) {
                        release = StreamSQL.this.releaseSQL.parseRelease(result, 7);
                        if (release.getIsLaterRelease() != null && release.getIsLaterRelease().booleanValue()) {
                            stream.setLaterRelease(release);
                        } else {
                            release.setIsLaterRelease(false);
                            stream.addRelease(release);
                        }
                        releases.put(releaseId, release);
                    } else {
                        release = (RestRelease)releases.get(releaseId);
                    }
                    String key = BaseAOPersistenceSQL.getString(result, 18);
                    String link = BaseAOPersistenceSQL.getString(result, 19);
                    if (key == null) continue;
                    release.addExtensionLink(new RestReleaseExtensionLinkResponse(key, link));
                }
                return Lists.newArrayList(streams.values());
            }
        });
    }

    public List<RestStream> listCustom(final String planId) throws SQLException {
        return this.sql(new IQuery<List<RestStream>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOStream.class, "s").select();
                StreamSQL.addStreamSelect(generator, "s");
                generator.from("s").where().col("s", "aoPlan").eq().numeric(planId);
            }

            @Override
            public List<RestStream> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    retVal.add(StreamSQL.this.parseStream(result));
                }
                return retVal;
            }
        });
    }

    private static void addStreamSelect(AOQueryGenerator generator, String tableKey) {
        generator.colId(tableKey).col(tableKey, "version").col(tableKey, "title").col(tableKey, "shortName").col(tableKey, "details").col(tableKey, "color").col(tableKey, "sortOrder");
    }

    private static void addExtensionLinkSelect(AOQueryGenerator generator, String tableKey) {
        generator.col(tableKey, "extensionKey").col(tableKey, "extensionLink");
    }

    private RestStream parseStream(ResultSet result) throws SQLException {
        String id = StreamSQL.getString(result, 1);
        Long version = StreamSQL.getLong(result, 2);
        String title = StreamSQL.getString(result, 3);
        String shortName = StreamSQL.getString(result, 4);
        String description = StreamSQL.getString(result, 5);
        String color = StreamSQL.getString(result, 6);
        Long sortOrder = StreamSQL.getLong(result, 7);
        RestStream retVal = new RestStream(id, title, description);
        retVal.setVersion(version);
        retVal.setShortName(shortName);
        retVal.setColor(color);
        retVal.setSortOrder(sortOrder);
        Set<String> restrictedTeamIds = this.streamToTeamSql.getRestrictedTeamIds(id);
        retVal.setTeams(restrictedTeamIds);
        return retVal;
    }
}

