/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.themes.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.themes.ITheme;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.themes.AOTheme;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.rest.entities.themes.RestTheme;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ThemeSQL
extends BaseAOPersistenceSQL {
    public ThemeSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public List<ITheme> getThemes(final String planId) throws SQLException {
        return this.sql(new IQuery<List<ITheme>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOTheme.class, "theme").select().colId("theme").col("theme", "version").col("theme", "title").col("theme", "details").col("theme", "color").col("theme", "percentage").col("theme", "sortOrder").from("theme").where().col("theme", "aoplan").eq().numeric(planId).orderBy().col("theme", "sortOrder");
            }

            @Override
            public List<ITheme> handleResult(ResultSet result) throws Exception {
                ArrayList themes = Lists.newArrayList();
                while (result.next()) {
                    String themeId = BaseAOPersistenceSQL.getString(result, 1);
                    Long version = ThemeSQL.getLong(result, 2);
                    String title = BaseAOPersistenceSQL.getString(result, 3);
                    String description = BaseAOPersistenceSQL.getString(result, 4);
                    String color = BaseAOPersistenceSQL.getString(result, 5);
                    Double percentage = BaseAOPersistenceSQL.getDouble(result, 6);
                    Long sortOrder = ThemeSQL.getLong(result, 7);
                    RestTheme theme = new RestTheme(themeId, title, description, color);
                    theme.setPercentage(percentage);
                    theme.setVersion(version);
                    theme.setSortOrder(sortOrder);
                    themes.add(theme);
                }
                return themes;
            }
        });
    }
}

