/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimateTableHelper;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ReplanningTableHelper;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemTableHelper;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class ResultSetParsingUtils {
    private ResultSetParsingUtils() {
    }

    static Optional<String> getOptionalString(ResultSet resultSet, int column) throws SQLException {
        String value = resultSet.getString(column);
        if (resultSet.wasNull() || Strings.isNullOrEmpty((String)value)) {
            return Optional.absent();
        }
        return Optional.of((Object)value);
    }

    static Optional<Integer> getOptionalInt(ResultSet resultSet, int column) throws SQLException {
        int value = resultSet.getInt(column);
        if (resultSet.wasNull()) {
            return Optional.absent();
        }
        return Optional.of((Object)value);
    }

    static Optional<Boolean> getOptionalBoolean(ResultSet resultSet, int column) throws SQLException {
        boolean value = resultSet.getBoolean(column);
        if (resultSet.wasNull()) {
            return Optional.absent();
        }
        return Optional.of((Object)value);
    }

    static Optional<Double> getOptionalDouble(ResultSet resultSet, int column) throws SQLException {
        double value = resultSet.getDouble(column);
        if (resultSet.wasNull()) {
            return Optional.absent();
        }
        return Optional.of((Object)value);
    }

    static Optional<Long> getOptionalLong(ResultSet resultSet, int column) throws SQLException {
        long value = resultSet.getLong(column);
        if (resultSet.wasNull()) {
            return Optional.absent();
        }
        return Optional.of((Object)value);
    }

    public static int calculateLevels(ResultSet result, boolean includeReplanning) throws SQLException {
        int workItemColumns = result.getMetaData().getColumnCount() - EstimateTableHelper.getColumnSelectCount();
        if (includeReplanning) {
            workItemColumns -= ReplanningTableHelper.getColumnSelectCount();
        }
        int singleItemColumnCount = WorkItemTableHelper.getColumnSelectCount(includeReplanning);
        int i = 1;
        while ((workItemColumns -= singleItemColumnCount) != 0) {
            if (workItemColumns < 0) {
                throw new RuntimeException("error while calculating hierarchy levels");
            }
            ++i;
        }
        return i;
    }
}

