/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItemExtensionLink;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemExtensionLink;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions.sql.ExtensionLinkSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.sql.WorkItemToResourceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemDependencySQL;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemEnrichmentUtils;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import com.radiantminds.roadmap.common.stats.MonitoredCallResult;
import com.radiantminds.roadmap.common.stats.MonitoredCallResultWrapper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class SubqueryDataEnrichment {
    private final WorkItemToResourceSQL workItemToResourceSQL;
    private final WorkItemDependencySQL workItemDependencySQL;
    private final ExtensionLinkSQL extensionLinkSQL;
    private final WorkItemEnrichmentUtils workItemEnrichmentUtils;

    SubqueryDataEnrichment(ActiveObjectsUtilities utilities, PortfolioResourcePersistence resourcePersistence, WorkItemExtension workItemExtension) {
        this.workItemToResourceSQL = new WorkItemToResourceSQL(utilities, resourcePersistence);
        this.workItemDependencySQL = new WorkItemDependencySQL(utilities);
        this.extensionLinkSQL = new ExtensionLinkSQL(utilities);
        this.workItemEnrichmentUtils = new WorkItemEnrichmentUtils(workItemExtension);
    }

    MonitoredCallResult<Void> enrichItems(String planId, boolean includeDoneDependencies, boolean includeReplanning, boolean enrichWithExtensions, ProgressConfiguration progressConfiguration, Map<String, RestWorkItem> itemMap) throws Exception {
        if (itemMap.isEmpty()) {
            return MonitoredCallResultWrapper.createEmpty();
        }
        this.dependencyEnrichment(planId, includeDoneDependencies, itemMap);
        this.extensionLinksEnrichment(planId, itemMap);
        this.resourceAssignmentEnrichment(includeReplanning, itemMap);
        if (enrichWithExtensions) {
            return this.workItemEnrichmentUtils.enrichItemsWithStatusAndProgress(progressConfiguration, itemMap);
        }
        return MonitoredCallResultWrapper.createEmpty();
    }

    private void resourceAssignmentEnrichment(boolean includeReplanning, Map<String, RestWorkItem> itemMap) throws SQLException {
        Map<String, Set<String>> resourceAssignments = this.workItemToResourceSQL.getResourceAssignmentsForWorkItems(itemMap.keySet(), false);
        for (String id : resourceAssignments.keySet()) {
            itemMap.get(id).setResources(resourceAssignments.get(id));
        }
        if (includeReplanning) {
            Map<String, Set<String>> replanningResourceAssignments = this.workItemToResourceSQL.getResourceAssignmentsForWorkItems(itemMap.keySet(), true);
            for (String id : replanningResourceAssignments.keySet()) {
                itemMap.get(id).setReplanningResources(replanningResourceAssignments.get(id));
            }
        }
    }

    private void extensionLinksEnrichment(String planId, Map<String, RestWorkItem> itemMap) throws SQLException {
        Map<String, List<IExtensionLink>> links = this.extensionLinkSQL.getExtensionLinksForPlan(planId, AOWorkItem.class);
        for (Map.Entry<String, List<IExtensionLink>> entry : links.entrySet()) {
            String itemId = entry.getKey();
            if (!itemMap.containsKey(itemId)) continue;
            List<IExtensionLink> extensionLinks = entry.getValue();
            List<IWorkItemExtensionLink> workItemExtensionLinks = this.toWorkItemExtensionLinks(extensionLinks);
            itemMap.get(itemId).setExtensionLinks(workItemExtensionLinks);
        }
    }

    private List<IWorkItemExtensionLink> toWorkItemExtensionLinks(List<IExtensionLink> extensionLinks) {
        ArrayList workItemExtesionLinks = Lists.newArrayList();
        for (IExtensionLink extensionLink : extensionLinks) {
            IWorkItemExtensionLink workItemExtensionLink = WorkItemExtensionLink.initFromLink(extensionLink);
            workItemExtesionLinks.add(workItemExtensionLink);
        }
        return workItemExtesionLinks;
    }

    private void dependencyEnrichment(String planId, boolean includeDoneDependencies, Map<String, RestWorkItem> itemMap) throws SQLException {
        Map<String, List<String>> dependencies = this.workItemDependencySQL.getDependenciesForPlan(planId, includeDoneDependencies);
        for (Map.Entry<String, List<String>> entry : dependencies.entrySet()) {
            String dependee = entry.getKey();
            if (!itemMap.containsKey(dependee)) continue;
            itemMap.get(dependee).setPrerequisites(entry.getValue());
        }
    }
}

