/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimationDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ReplanningRelationsDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemDataBlock;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class WorkItemQueryRowData {
    private final ImmutableList<WorkItemDataBlock> workItemData;
    private final EstimationDataBlock estimationData;
    private final ReplanningRelationsDataBlock replanningRelationsDataBlock;

    WorkItemQueryRowData(List<WorkItemDataBlock> workItemData, @Nullable EstimationDataBlock estimationData, @Nullable ReplanningRelationsDataBlock replanningRelationsDataBlock) {
        Preconditions.checkNotNull(workItemData, (Object)"work item data list must not be null");
        Preconditions.checkArgument((!workItemData.isEmpty() ? 1 : 0) != 0, (Object)"work item data must not be empty");
        this.workItemData = ImmutableList.copyOf(workItemData);
        this.estimationData = estimationData;
        this.replanningRelationsDataBlock = replanningRelationsDataBlock;
    }

    List<WorkItemDataBlock> getWorkItemData() {
        return this.workItemData;
    }

    Optional<EstimationDataBlock> getEstimationData() {
        return Optional.fromNullable((Object)this.estimationData);
    }

    Optional<ReplanningRelationsDataBlock> getReplanningRelationData() {
        return Optional.fromNullable((Object)this.replanningRelationsDataBlock);
    }

    public String toString() {
        return "WorkItemQueryRow [workItemData=" + this.workItemData + ", estimationData=" + this.estimationData + ", replanningRowData=" + this.replanningRelationsDataBlock + "]";
    }
}

