/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ResultSetParsingUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemTableHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
class WorkItemRowDataReader {
    private static final Log LOGGER;
    private static final Map<String, Integer> INDICES;
    private static final Map<String, Integer> REPLANNING_INDICES;

    WorkItemRowDataReader() {
    }

    List<WorkItemDataBlock> readRowData(ResultSet resultSet, int levels, boolean includeReplanning, Map<String, WorkItemDataBlock> workItemDataBlocks) throws SQLException {
        int offset;
        String id;
        LOGGER.debug("read from result set: %s with %s levels", resultSet, levels);
        ArrayList itemData = Lists.newArrayList();
        for (int i = 0; i < levels && (id = resultSet.getString(offset = i * WorkItemTableHelper.getColumnSelectCount(includeReplanning) + 1)) != null; ++i) {
            WorkItemDataBlock data = workItemDataBlocks.get(id);
            if (data == null) {
                int type = resultSet.getInt(offset + WorkItemRowDataReader.getColumnIndex("type"));
                String title = (String)ResultSetParsingUtils.getOptionalString(resultSet, offset + WorkItemRowDataReader.getColumnIndex("title")).orNull();
                Long sortOrder = (Long)ResultSetParsingUtils.getOptionalLong(resultSet, offset + WorkItemRowDataReader.getColumnIndex("sortOrder")).orNull();
                long version = resultSet.getLong(offset + WorkItemRowDataReader.getColumnIndex("version"));
                int status = resultSet.getInt(offset + WorkItemRowDataReader.getColumnIndex("status"));
                boolean originalEstimates = resultSet.getBoolean(offset + WorkItemRowDataReader.getColumnIndex("hasOriginalEstimates"));
                String description = null;
                String details = (String)ResultSetParsingUtils.getOptionalString(resultSet, offset + WorkItemRowDataReader.getColumnIndex("details")).orNull();
                Long earliestStart = (Long)ResultSetParsingUtils.getOptionalLong(resultSet, offset + WorkItemRowDataReader.getColumnIndex("aoEarliestStart")).orNull();
                Long targetStart = (Long)ResultSetParsingUtils.getOptionalLong(resultSet, offset + WorkItemRowDataReader.getColumnIndex("aoTargetStart")).orNull();
                Long targetEnd = (Long)ResultSetParsingUtils.getOptionalLong(resultSet, offset + WorkItemRowDataReader.getColumnIndex("aoTargetEnd")).orNull();
                Double businessValue = (Double)ResultSetParsingUtils.getOptionalDouble(resultSet, offset + WorkItemRowDataReader.getColumnIndex("aoBusinessValue")).orNull();
                String teamId = (String)ResultSetParsingUtils.getOptionalString(resultSet, offset + WorkItemRowDataReader.getColumnIndex("aoTeam")).orNull();
                String sprintId = (String)ResultSetParsingUtils.getOptionalString(resultSet, offset + WorkItemRowDataReader.getColumnIndex("aoSprint")).orNull();
                String streamId = resultSet.getString(offset + WorkItemRowDataReader.getColumnIndex("aoStream"));
                String themeId = resultSet.getString(offset + WorkItemRowDataReader.getColumnIndex("aoTheme"));
                String releaseId = (String)ResultSetParsingUtils.getOptionalString(resultSet, offset + WorkItemRowDataReader.getColumnIndex("aoRelease")).orNull();
                Integer replanningStatus = null;
                if (includeReplanning) {
                    replanningStatus = (Integer)ResultSetParsingUtils.getOptionalInt(resultSet, offset + WorkItemTableHelper.COLUMNS.size() + WorkItemRowDataReader.getReplanningColumnIndex("replanningStatus")).orNull();
                }
                data = new WorkItemDataBlock(id, type, sortOrder, version, status, originalEstimates, title, description, details, earliestStart, targetStart, targetEnd, businessValue, teamId, sprintId, streamId, releaseId, themeId, replanningStatus);
                workItemDataBlocks.put(id, data);
            }
            itemData.add(data);
        }
        LOGGER.debug("return item data: %s", Joiner.on((String)",").join((Iterable)itemData));
        return itemData;
    }

    private static int getColumnIndex(String column) {
        return INDICES.get(column) + 1;
    }

    private static int getReplanningColumnIndex(String column) {
        return REPLANNING_INDICES.get(column) + 1;
    }

    static {
        int i;
        LOGGER = Log.with(WorkItemRowDataReader.class);
        INDICES = Maps.newHashMap();
        REPLANNING_INDICES = Maps.newHashMap();
        for (i = 0; i < WorkItemTableHelper.COLUMNS.size(); ++i) {
            INDICES.put(WorkItemTableHelper.COLUMNS.get(i), i);
        }
        for (i = 0; i < WorkItemTableHelper.REPLANNING_COLUMNS.size(); ++i) {
            REPLANNING_INDICES.put(WorkItemTableHelper.REPLANNING_COLUMNS.get(i), i);
        }
    }
}

