/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.AOCustomWording;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions.AOExtensionLink;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.solutions.AOSolutionStore;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableExporter;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IdMapper;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PortProgress;
import com.radiantminds.roadmap.common.data.persistence.ao.port.TableForeignKeySorter;
import com.radiantminds.roadmap.common.data.persistence.ao.port.TranslationException;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlExportablePersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.BaseTransactionalAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.XmlExportablePersistence;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlanExporter
extends BaseTransactionalAOPersistenceSQL {
    private static final List<Class<?>> excludedClazzes = Lists.newArrayList((Object[])new Class[]{AOCustomWording.class, AOSolutionStore.class});
    private final ActiveObjectsUtilities activeObjectsUtilities;
    private final XmlExportablePersistenceIndex index;
    private final MetaDataUtils metaDataUtils;

    public PlanExporter(ActiveObjectsUtilities activeObjectsUtilities, XmlExportablePersistenceIndex index, MetaDataUtils metaDataUtils) {
        super(activeObjectsUtilities);
        this.activeObjectsUtilities = activeObjectsUtilities;
        this.index = index;
        this.metaDataUtils = metaDataUtils;
    }

    public String export(String planId, PortProgress progress, boolean anonymise, boolean excludeLinks) throws ParserConfigurationException, TransformerException, SQLException, TranslationException {
        List<XmlExportablePersistence> persistences = this.index.getPersistenceBeans();
        ArrayList countQueries = Lists.newArrayList();
        for (XmlExportablePersistence xmlExportablePersistence : persistences) {
            if (excludeLinks && xmlExportablePersistence.getDbInterfaceClass() == AOExtensionLink.class || excludedClazzes.contains(xmlExportablePersistence.getDbInterfaceClass())) continue;
            countQueries.add(AOTableExporter.getRowCount(xmlExportablePersistence, planId));
        }
        int totalRows = 0;
        for (Integer rowCount : this.handleInTransaction(countQueries)) {
            totalRows += rowCount.intValue();
        }
        progress.setTotal(totalRows);
        IdMapper idMapper = new IdMapper(this.index);
        DocumentBuilder docBuilder = XmlUtils.getDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("roadmap");
        rootElement.setAttribute("version", this.metaDataUtils.getVersion().toString());
        rootElement.setAttribute("timestamp", String.valueOf(System.currentTimeMillis()));
        doc.appendChild(rootElement);
        ArrayList queries = Lists.newArrayList();
        AOTableExporter tableExporter = new AOTableExporter(this.activeObjectsUtilities);
        for (XmlExportablePersistence persistence : TableForeignKeySorter.getSortedPersistences(persistences)) {
            if (excludeLinks && persistence.getDbInterfaceClass() == AOExtensionLink.class || excludedClazzes.contains(persistence.getDbInterfaceClass())) continue;
            IQuery<Element> query = tableExporter.getQuery(planId, persistence, doc, idMapper, progress, anonymise);
            queries.add(query);
        }
        for (Element tableElement : this.handleInTransaction(queries)) {
            rootElement.appendChild(tableElement);
        }
        return PlanExporter.getStringFromDocument(doc);
    }

    private static String getStringFromDocument(Document document) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(domSource, result);
        return writer.toString();
    }
}

