/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port.dynamics;

import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableImportData;
import com.radiantminds.roadmap.common.data.persistence.ao.port.dynamics.DynamicValueHandler;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicValueHandlers {
    private static final String DYNAMIC_ROW_PROPERTY = "dynamic";
    private final List<DynamicValueHandler> handlers;

    @Autowired
    public DynamicValueHandlers(List<DynamicValueHandler> handlers) {
        this.handlers = handlers;
    }

    public void applyTo(AOTableImportData data) {
        for (Map<String, String> row : data.getRows()) {
            if (!row.containsKey(DYNAMIC_ROW_PROPERTY) || !"true".equals(row.get(DYNAMIC_ROW_PROPERTY))) continue;
            for (String key : row.keySet()) {
                for (DynamicValueHandler handler : this.handlers) {
                    String rowValue = row.get(key);
                    Matcher matcher = handler.getMatchPattern().matcher(rowValue);
                    if (!matcher.matches()) continue;
                    String replacementString = handler.getReplacement(matcher);
                    String newRowValue = String.format("%s%s%s", rowValue.substring(0, matcher.start()), replacementString, rowValue.substring(matcher.end()));
                    row.put(key, newRowValue);
                }
            }
            row.remove(DYNAMIC_ROW_PROPERTY);
        }
    }
}

