/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port.legacy;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.data.persistence.ao.port.AOTableImportData;
import com.radiantminds.roadmap.common.data.persistence.ao.port.legacy.LegacyDocumentModifier;
import com.radiantminds.roadmap.common.utils.JPOVersion;
import com.radiantminds.roadmap.common.utils.JPOVersionException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocumentLegacyChecker {
    private static final Log LOGGER = Log.with(DocumentLegacyChecker.class);
    final List<LegacyDocumentModifier> modifiers;

    @Autowired
    public DocumentLegacyChecker(List<LegacyDocumentModifier> modifiers) {
        this.modifiers = modifiers;
    }

    public void adaptDocument(String version, List<AOTableImportData> importData) throws JPOVersionException {
        JPOVersion modelVersion = new JPOVersion(version);
        for (LegacyDocumentModifier modifier : this.modifiers) {
            if (!modelVersion.isOlderThan(modifier.isRelevantBeforeVersion())) continue;
            LOGGER.info(String.format("Applying '%s' to legacy version import XML (%s < %s).", modifier.getClass().getSimpleName(), version, modifier.isRelevantBeforeVersion()), new Object[0]);
            modifier.modify(importData);
        }
    }
}

