/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.upgrade.tasks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.BaseTransactionalAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.upgrade.BaseUpgradeTask;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class U_01201_WorkItemsToStreamsUpgradeTask
extends BaseUpgradeTask {
    @Override
    protected int getDataModelVersion() {
        return 1201;
    }

    @Override
    protected void performUpgrade(ActiveObjectsUtilities utils, PersistenceIndex persistenceIndex) throws Exception {
        UpgradeSQL sql = new UpgradeSQL(this, utils);
        sql.perform();
    }

    @Override
    protected boolean migrateOnUpgrade() {
        return false;
    }

    private class UpgradeSQL
    extends BaseTransactionalAOPersistenceSQL {
        private final BaseUpgradeTask task;
        private final ActiveObjectsUtilities utils;

        public UpgradeSQL(BaseUpgradeTask task, ActiveObjectsUtilities utils) {
            super(utils);
            this.task = task;
            this.utils = utils;
        }

        private Connection getConnection() throws SQLException {
            return this.task.getOrCreateConnection(this.utils.getAccessor());
        }

        public void perform() throws Exception {
            Map<String, String> workItemsToUpgrade = this.getMissingWorkItemStreamAssignments();
            ArrayList updates = Lists.newArrayList();
            for (final Map.Entry<String, String> entry : workItemsToUpgrade.entrySet()) {
                updates.add(new IUpdate(){

                    @Override
                    public void sql(AOQueryGenerator generator) throws Exception {
                        generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "aoStream").eq().numeric((String)entry.getValue()).where().colIdNoAlias("w").eq().numeric((String)entry.getKey());
                    }
                });
            }
            this.handleUpdatesInTransaction(updates, this.getConnection());
        }

        private Map<String, String> getMissingWorkItemStreamAssignments() throws SQLException {
            return this.sql(new IQuery<Map<String, String>>(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOWorkItem.class, "w").withTable(AOWorkItem.class, "w2").withTable(AOStream.class, "s").select().colId("w").colId("s").from("w").leftJoin().table("s").on().col("w", "aoplan").eq().col("s", "aoplan").where().colId("w").raw("NOT IN(").select().col("w2", "aoParent").from("w2").where().col("w2", "aoParent").isNotNull().raw(")");
                }

                @Override
                public Map<String, String> handleResult(ResultSet result) throws Exception {
                    HashMap retVal = Maps.newHashMap();
                    while (result.next()) {
                        String workItemId = BaseAOPersistenceSQL.getString(result, 1);
                        String streamId = BaseAOPersistenceSQL.getString(result, 2);
                        if (retVal.containsKey(workItemId)) continue;
                        retVal.put(workItemId, streamId);
                    }
                    return retVal;
                }
            }, this.getConnection());
        }
    }
}

